/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ImmutableMap;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface MapBuilder<K, V, M extends Map<K, V>> {
    public MapBuilder<K, V, M> put(K var1, V var2);

    public MapBuilder<K, V, M> putList(K var1, List<?> var2);

    public MapBuilder<K, V, M> putAll(Map<K, V> var1);

    public int size();

    public M build();

    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap() {
        return ImmutableMap.of();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1) {
        return MapBuilder.immutableMapBuilder().put(k1, v1).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2) {
        return MapBuilder.immutableMapBuilder().put(k1, v1).put(k2, v2).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        return MapBuilder.immutableMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return MapBuilder.immutableMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return MapBuilder.immutableMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(Map<K, V> map) {
        return MapBuilder.immutableMapBuilder().putAll(map).build();
    }

    public static <K, V> SimpleMapBuilder<K, V> simpleMapBuilder() {
        return MapBuilder.simpleMapBuilder(LinkedHashMap::new);
    }

    public static <K, V> SimpleMapBuilder<K, V> simpleMapBuilder(Supplier<Map<K, V>> supplier) {
        return new SimpleMapBuilder(supplier.get());
    }

    public static <K, V> Map<K, V> simpleMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1) {
        return MapBuilder.simpleMapBuilder().put(k1, v1).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2) {
        return MapBuilder.simpleMapBuilder().put(k1, v1).put(k2, v2).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        return MapBuilder.simpleMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return MapBuilder.simpleMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return MapBuilder.simpleMapBuilder().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).build();
    }

    public static <K, V> Map<K, V> simpleMap(Map<K, V> map) {
        return MapBuilder.simpleMapBuilder().putAll(map).build();
    }

    public static class SimpleMapBuilder<K, V>
    implements MapBuilder<K, V, Map<K, V>> {
        private final Map<K, V> builder;

        @Override
        public MapBuilder<K, V, Map<K, V>> put(K key, V value) {
            if (value != null) {
                this.builder.put(key, value);
            }
            return this;
        }

        @Override
        public MapBuilder<K, V, Map<K, V>> putList(K key, List<?> values) {
            if (values != null && !values.isEmpty()) {
                this.builder.put(key, values);
            }
            return this;
        }

        @Override
        public MapBuilder<K, V, Map<K, V>> putAll(Map<K, V> map) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public Map<K, V> build() {
            return this.builder;
        }

        private SimpleMapBuilder(Map<K, V> builder) {
            this.builder = builder;
        }
    }

    public static class ImmutableMapBuilder<K, V>
    implements MapBuilder<K, V, ImmutableMap<K, V>> {
        private final ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();

        @Override
        public MapBuilder<K, V, ImmutableMap<K, V>> put(K key, V value) {
            if (value != null) {
                this.builder.put(key, value);
            }
            return this;
        }

        @Override
        public MapBuilder<K, V, ImmutableMap<K, V>> putList(K key, List<?> values) {
            if (values != null && !values.isEmpty()) {
                this.builder.put(key, values);
            }
            return this;
        }

        @Override
        public MapBuilder<K, V, ImmutableMap<K, V>> putAll(Map<K, V> map) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
            return this;
        }

        @Override
        public int size() {
            return (Integer)ReflectionUtil.fieldValue(this.builder, "size");
        }

        @Override
        public ImmutableMap<K, V> build() {
            return this.builder.build();
        }

        private ImmutableMapBuilder() {
        }
    }
}

