/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Strings;
import io.polyglotted.common.model.GeoPoint;
import io.polyglotted.common.util.DateFormatters;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.Sanitizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public abstract class BaseSerializer {
    public static final ObjectMapper MAPPER = BaseSerializer.buildMapper();
    public static final ObjectMapper ORDERED_MAPPER = BaseSerializer.buildMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    private static ObjectMapper buildMapper() {
        return new ObjectMapper().registerModule((Module)BaseSerializer.baseModule()).registerModule((Module)new GuavaModule()).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
    }

    public static <T> byte[] serializeBytes(T object) {
        return MAPPER.writeValueAsBytes(object);
    }

    public static String serialize(Object object) {
        return MAPPER.writeValueAsString(object);
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        return (T)MAPPER.readValue(bytes, clazz);
    }

    public static <T> T deserialize(InputStream stream, Class<T> clazz) {
        return (T)MAPPER.readValue(stream, clazz);
    }

    public static <T> T deserialize(Reader reader, Class<T> clazz) {
        return (T)MAPPER.readValue(reader, clazz);
    }

    public static Map<String, Object> deserialize(byte[] bytes) {
        return BaseSerializer.deserialize(bytes, MapRetriever.MAP_CLASS);
    }

    public static Map<String, Object> deserialize(String json) {
        return BaseSerializer.deserialize(json, MapRetriever.MAP_CLASS);
    }

    public static void writeNotEmptyMap(JsonGenerator gen, String name, Map<?, ?> map) throws IOException {
        if (!map.isEmpty()) {
            gen.writeObjectField(name, map);
        }
    }

    public static void writeNotEmptyColl(JsonGenerator gen, String name, Collection<?> coll) throws IOException {
        if (!coll.isEmpty()) {
            gen.writeObjectField(name, coll);
        }
    }

    public static void writeNotNull(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }

    public static void writeNotNullOrEmpty(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj instanceof Map) {
            BaseSerializer.writeNotEmptyMap(gen, name, (Map)obj);
        } else if (obj instanceof Collection) {
            BaseSerializer.writeNotEmptyColl(gen, name, (Collection)obj);
        } else if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }

    private static SimpleModule baseModule() {
        SimpleModule module = new SimpleModule("BaseSerializer");
        module.addSerializer(Double.TYPE, (JsonSerializer)new DoubleSerializer());
        module.addSerializer(LocalDate.class, new ToStringSerializer());
        module.addSerializer(LocalTime.class, new ToStringSerializer());
        module.addSerializer(OffsetTime.class, new ToStringSerializer());
        module.addSerializer(ZonedDateTime.class, new ToStringSerializer());
        module.addSerializer(OffsetDateTime.class, new ToStringSerializer());
        module.addSerializer(LocalDateTime.class, new ToStringSerializer());
        module.addSerializer(UUID.class, new ToStringSerializer());
        module.addSerializer(GeoPoint.class, new ToStringSerializer());
        module.addSerializer(InetAddress.class, (JsonSerializer)new IpSerializer());
        module.addDeserializer(String.class, (JsonDeserializer)new StdStringSerializer());
        module.addDeserializer(Long.TYPE, (JsonDeserializer)new DateLongSerializer(Long.TYPE, 0L));
        module.addDeserializer(Long.class, (JsonDeserializer)new DateLongSerializer(Long.class, null));
        module.addDeserializer(LocalDate.class, new SanitizeSerializer<LocalDate>(LocalDate.class));
        module.addDeserializer(LocalTime.class, new SanitizeSerializer<LocalTime>(LocalTime.class));
        module.addDeserializer(OffsetTime.class, new SanitizeSerializer<OffsetTime>(OffsetTime.class));
        module.addDeserializer(ZonedDateTime.class, new SanitizeSerializer<ZonedDateTime>(ZonedDateTime.class));
        module.addDeserializer(OffsetDateTime.class, new SanitizeSerializer<OffsetDateTime>(OffsetDateTime.class));
        module.addDeserializer(LocalDateTime.class, new SanitizeSerializer<LocalDateTime>(LocalDateTime.class));
        return module;
    }

    private static class SanitizeSerializer<T>
    extends StdDeserializer<T> {
        SanitizeSerializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String result = StringDeserializer.instance.deserialize(p, ctxt);
            return (T)(Strings.isNullOrEmpty((String)result) ? null : Sanitizer.sanitize(this._valueClass, result));
        }
    }

    private static class DateLongSerializer
    extends StdDeserializer<Long> {
        private final NumberDeserializers.LongDeserializer backoff;

        DateLongSerializer(Class<Long> vc, Long nvl) {
            super(vc);
            this.backoff = new NumberDeserializers.LongDeserializer(vc, nvl);
        }

        public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value;
            if (p.getCurrentTokenId() == 6 && (value = p.getText().trim()).length() > 0) {
                try {
                    return DateFormatters.parseDateTime(value).toInstant().toEpochMilli();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            return this.backoff.deserialize(p, ctxt);
        }
    }

    private static class StdStringSerializer
    extends StdDeserializer<String> {
        StdStringSerializer() {
            super(String.class);
        }

        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String result = StringDeserializer.instance.deserialize(p, ctxt);
            return Strings.isNullOrEmpty((String)result) ? null : result;
        }
    }

    private static class IpSerializer
    extends JsonSerializer<InetAddress> {
        private IpSerializer() {
        }

        public void serialize(InetAddress src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src != null) {
                gen.writeString(src.getHostAddress());
            }
        }
    }

    private static class ToStringSerializer<T>
    extends JsonSerializer<T> {
        private ToStringSerializer() {
        }

        public void serialize(T src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src != null) {
                gen.writeString(src.toString());
            }
        }
    }

    private static class DoubleSerializer
    extends JsonSerializer<Double> {
        private DoubleSerializer() {
        }

        public void serialize(Double src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src == (double)src.longValue()) {
                gen.writeNumber(src.longValue());
            } else {
                gen.writeNumber(src.doubleValue());
            }
        }
    }
}

