/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ImmutableSortedMap;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.EnumCache;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.NullUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class ReflectionUtil {
    private static final Map<Class<?>, Object> JAVA_DEFAULTS = ((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put(Boolean.TYPE, (Object)false)).put(Character.TYPE, Character.valueOf('\u0000'))).put(Byte.TYPE, Byte.valueOf("0"))).put(Short.TYPE, Short.valueOf("0"))).put(Integer.TYPE, (Object)0)).put(Long.TYPE, Long.valueOf("0"))).put(Float.TYPE, Float.valueOf("0.0"))).put(Double.TYPE, (Object)0.0)).build();

    public static Class<?> safeClass(Object object) {
        return NullUtil.nonNullFn(object, Object::getClass, Void.class);
    }

    public static Class<?> safeForName(String className) {
        try {
            return className == null ? null : Class.forName(className);
        }
        catch (ClassNotFoundException cfe) {
            return null;
        }
    }

    public static Object create(Class<?> clazz) {
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        return constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : ReflectionUtil.initWithArgs(constructor);
    }

    public static Object initWithArgs(Constructor<?> constructor) throws Exception {
        Class<?>[] params = constructor.getParameterTypes();
        Object[] initargs = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            initargs[i] = JAVA_DEFAULTS.get(params[i]);
        }
        return constructor.newInstance(initargs);
    }

    public static Object asEnum(Class<?> clazz, String value) {
        return ReflectionUtil.isEnum(clazz) ? EnumCache.fetchEnumValueFor(clazz, value) : value;
    }

    public static boolean isEnum(Class<?> clazz) {
        return Objects.requireNonNull(clazz, "null enum class").isEnum() || Enum.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?> from, Class<?> to) {
        return to != null && from.isAssignableFrom(to);
    }

    public static <T> T safeFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtil.declaredField(object.getClass(), fieldName);
        return field == null ? null : (T)ReflectionUtil.fieldValue(object, field);
    }

    public static <T> T fieldValue(Object object, String fieldName) {
        return ReflectionUtil.fieldValue(object, ReflectionUtil.declaredField(object.getClass(), fieldName));
    }

    public static <T> T fieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to find field value for " + field, e);
        }
    }

    public static <T> T fieldValue(T object, String fieldName, Object value) {
        return ReflectionUtil.fieldValue(object, ReflectionUtil.declaredField(object.getClass(), fieldName), value);
    }

    public static <T> T fieldValue(T object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to set field value for " + field, e);
        }
    }

    public static Field declaredField(Class<?> clazz, String name) {
        Field result = null;
        while (clazz != Object.class) {
            try {
                result = clazz.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return result;
    }

    public static MapResult fieldValues(Object object) {
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder(ImmutableSortedMap::naturalOrder);
        for (Field field : ReflectionUtil.declaredFields(object.getClass())) {
            Object value;
            if (!ReflectionUtil.isFieldSerializable(field) || (value = ReflectionUtil.fieldValue(object, field)) == null) continue;
            builder.put(field.getName(), value);
        }
        return builder.result();
    }

    public static List<Field> declaredFields(Class<?> clazz) {
        ListBuilder.ImmutableListBuilder<Field> result = ListBuilder.immutableListBuilder();
        while (clazz != null && !Object.class.equals(clazz)) {
            for (Field field : clazz.getDeclaredFields()) {
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return result.build();
    }

    public static boolean isFieldSerializable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !Modifier.isVolatile(modifiers);
    }

    public static <T> T safeInvoke(Object object, String methodName, Object ... params) {
        if (object == null) {
            return null;
        }
        Class[] paramClasses = CollUtil.transformList(Arrays.asList(params), Object::getClass).toArray(new Class[0]);
        return ReflectionUtil.safeInvoke(object.getClass(), object, methodName, paramClasses, params);
    }

    public static <T> T safeInvoke(Class<?> clazz, Object object, String methodName, Class<?>[] paramClasses, Object ... params) {
        return ReflectionUtil.safeInvoke(ReflectionUtil.declaredMethod(clazz, methodName, paramClasses), object, params);
    }

    public static <T> T safeInvoke(Method method, Object object, Object ... params) {
        try {
            return (T)(method == null ? null : method.invoke(object, params));
        }
        catch (Exception e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
    }

    public static Method declaredMethod(Class<?> clazz, String methodName, Class<?>[] paramClasses) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramClasses);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuch) {
            return null;
        }
    }

    public static Class<?> getCollTypeArg(Field field) {
        return ReflectionUtil.getTypeArg(ReflectionUtil.getFieldTypeArgs(field)[0]);
    }

    public static Pair<Class<?>, Class<?>> getMapTypeArgs(Field field) {
        Type[] fieldTypeArgs = ReflectionUtil.getFieldTypeArgs(field);
        return Pair.pair(ReflectionUtil.getTypeArg(fieldTypeArgs[0]), ReflectionUtil.getTypeArg(fieldTypeArgs[1]));
    }

    public static Type[] getFieldTypeArgs(Field field) {
        return ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
    }

    public static Class<?> getTypeArg(Type typeArg) {
        return typeArg instanceof Class ? (Class)typeArg : Object.class;
    }

    public static <T extends Annotation> T annotation(Field field, Class<T> clazz) {
        return field.isAnnotationPresent(clazz) ? (T)field.getAnnotation(clazz) : null;
    }

    public static Class<?> detectValueClass(Object value, Supplier<Field> supplier) {
        if (value instanceof Collection) {
            return Iterable.class;
        }
        if (value instanceof Map) {
            return Map.class;
        }
        Field field = supplier.get();
        return field == null ? Void.class : (ReflectionUtil.isEnum(field.getType()) ? String.class : field.getType());
    }
}

