/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public interface ListBuilder<E, L extends Collection<E>> {
    public ListBuilder<E, L> add(E var1);

    public ListBuilder<E, L> addAll(Iterable<? extends E> var1);

    public int size();

    public L build();

    default public L atleastOne() {
        Assertions.checkGte(this.size(), 1, "size");
        return this.build();
    }

    public static <E> ImmutableListBuilder<E> immutableListBuilder() {
        return new ImmutableListBuilder();
    }

    public static <E> ImmutableList<E> immutableList() {
        return ImmutableList.of();
    }

    @SafeVarargs
    public static <E> ImmutableList<E> immutableList(E ... elems) {
        return ListBuilder.immutableList(Arrays.asList(elems));
    }

    public static <E> ImmutableList<E> immutableList(Iterable<? extends E> coll) {
        return ListBuilder.immutableListBuilder().addAll(coll).build();
    }

    public static <E> SimpleListBuilder<E> simpleListBuilder() {
        return ListBuilder.simpleListBuilder(LinkedList::new);
    }

    public static <E> SimpleListBuilder<E> simpleListBuilder(Supplier<List<E>> supplier) {
        return new SimpleListBuilder(supplier.get());
    }

    public static <E> List<E> simpleList() {
        return new LinkedList();
    }

    @SafeVarargs
    public static <E> List<E> simpleList(E ... elems) {
        return ListBuilder.simpleList(Arrays.asList(elems));
    }

    public static <E> List<E> simpleList(Iterable<? extends E> coll) {
        return ListBuilder.simpleListBuilder().addAll(coll).build();
    }

    public static <E> SimpleSetBuilder<E> simpleSetBuilder() {
        return ListBuilder.simpleSetBuilder(TreeSet::new);
    }

    public static <E> SimpleSetBuilder<E> simpleSetBuilder(Supplier<Set<E>> supplier) {
        return new SimpleSetBuilder(supplier.get());
    }

    @SafeVarargs
    public static <E> Set<E> immutableSet(E ... elems) {
        return ListBuilder.immutableSet(Arrays.asList(elems));
    }

    public static <E> Set<E> immutableSet(SimpleSetBuilder<E> builder) {
        return ListBuilder.immutableSet(builder.build());
    }

    public static <E> Set<E> immutableSet(Iterable<E> iterable) {
        return ImmutableSet.copyOf(iterable);
    }

    @SafeVarargs
    public static <E> Set<E> immutableSortedSet(E ... elems) {
        return ListBuilder.immutableSortedSet(Arrays.asList(elems));
    }

    public static <E> Set<E> immutableSortedSet(SimpleSetBuilder<E> builder) {
        return ListBuilder.immutableSortedSet(builder.build());
    }

    public static <E> Set<E> immutableSortedSet(Iterable<E> iterable) {
        return ImmutableSortedSet.copyOf(iterable);
    }

    public static class SimpleSetBuilder<E>
    implements ListBuilder<E, Set<E>> {
        private final Set<E> builder;

        @Override
        public ListBuilder<E, Set<E>> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        @Override
        public ListBuilder<E, Set<E>> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add(elem);
            }
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public Set<E> build() {
            return this.builder;
        }

        private SimpleSetBuilder(Set<E> builder) {
            this.builder = builder;
        }
    }

    public static class SimpleListBuilder<E>
    implements ListBuilder<E, List<E>> {
        private final List<E> builder;

        @Override
        public ListBuilder<E, List<E>> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        @Override
        public ListBuilder<E, List<E>> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add(elem);
            }
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public List<E> build() {
            return this.builder;
        }

        private SimpleListBuilder(List<E> builder) {
            this.builder = builder;
        }
    }

    public static class ImmutableListBuilder<E>
    implements ListBuilder<E, ImmutableList<E>> {
        private final ImmutableList.Builder<E> builder = ImmutableList.builder();

        @Override
        public ListBuilder<E, ImmutableList<E>> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        @Override
        public ListBuilder<E, ImmutableList<E>> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add(elem);
            }
            return this;
        }

        @Override
        public int size() {
            return (Integer)ReflectionUtil.fieldValue(this.builder, "size");
        }

        @Override
        public ImmutableList<E> build() {
            return this.builder.build();
        }

        private ImmutableListBuilder() {
        }
    }
}

