/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.StrUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class HttpRequestBuilder {
    @NonNull
    private final HttpReqType reqType;
    @NonNull
    private final String baseUri;
    private final String path;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private final Multimap<String, String> params = ArrayListMultimap.create();
    private HttpEntity httpEntity;

    public HttpRequestBuilder withBasicAuth(String user, String passwd) {
        return this.withAuth("Basic " + Base64.encodeBase64URLSafeString((byte[])(user + ":" + passwd).getBytes()));
    }

    public HttpRequestBuilder withBearerAuth(String token) {
        return this.withAuth("Bearer " + token);
    }

    public HttpRequestBuilder withAuth(String authHeader) {
        if (authHeader != null) {
            this.withHeader("Authorization", authHeader);
        }
        return this;
    }

    public HttpRequestBuilder withHeader(String key, Object value) {
        if (value != null) {
            this.headers.put(key, value.toString());
        }
        return this;
    }

    public HttpRequestBuilder withCollParam(String key, Collection<?> values) {
        for (Object value : values) {
            this.withParam(key, value);
        }
        return this;
    }

    public HttpRequestBuilder withParam(String key, Object value) {
        if (value != null) {
            this.params.put((Object)key, (Object)value.toString());
        }
        return this;
    }

    public HttpRequestBuilder withParams(HttpRequestParams params) {
        return params.update(this);
    }

    public HttpRequestBuilder withContent(Object content) {
        this.headers.put("Content-Type", "application/json");
        this.httpEntity = new ByteArrayEntity(BaseSerializer.serializeBytes(content));
        return this;
    }

    public HttpRequestBuilder withJson(String json) {
        this.headers.put("Content-Type", "application/json");
        this.httpEntity = new StringEntity(json);
        return this;
    }

    public HttpRequestBuilder withInput(String contentType, InputStream stream) {
        this.headers.put("Content-Type", contentType);
        this.httpEntity = new InputStreamEntity(stream);
        return this;
    }

    public <H extends HttpRequestBase> H request() {
        Object request = this.reqType.create(this.buildUri());
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        if (this.httpEntity != null) {
            ((HttpEntityEnclosingRequest)request).setEntity(this.httpEntity);
        }
        return request;
    }

    private URI buildUri() {
        URIBuilder uriBuilder = new URIBuilder(Objects.requireNonNull(this.baseUri, "baseUri is null"));
        if (StrUtil.notNullOrEmpty(this.path)) {
            uriBuilder.setPath(this.path);
        }
        for (Map.Entry entry : this.params.entries()) {
            uriBuilder.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return uriBuilder.build();
    }

    public HttpRequestBuilder(@NonNull HttpReqType reqType, @NonNull String baseUri, String path) {
        if (reqType == null) {
            throw new NullPointerException("reqType");
        }
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        this.reqType = reqType;
        this.baseUri = baseUri;
        this.path = path;
    }

    @NotThreadSafe
    public static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public String getMethod() {
            return "DELETE";
        }

        HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }
    }

    public static abstract class HttpRequestParams {
        public abstract HttpRequestBuilder update(HttpRequestBuilder var1);
    }

    public static enum HttpReqType {
        GET{

            HttpGet create(URI uri) {
                return new HttpGet(uri);
            }
        }
        ,
        POST{

            HttpPost create(URI uri) {
                return new HttpPost(uri);
            }
        }
        ,
        PUT{

            HttpPut create(URI uri) {
                return new HttpPut(uri);
            }
        }
        ,
        DELETE{

            HttpDeleteWithBody create(URI uri) {
                return new HttpDeleteWithBody(uri);
            }
        };


        abstract <H extends HttpRequestBase> H create(URI var1);
    }
}

