/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.reflect.TypeToken;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.EnumCache;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.StrUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MapRetriever {
    public static final Class<Map<String, Object>> MAP_CLASS = new TypeToken<Map<String, Object>>(){}.getRawType();
    public static final Class<Map<String, String>> STRMAP_CLASS = new TypeToken<Map<String, String>>(){}.getRawType();
    public static final Class<List<Map<String, Object>>> MAP_LIST_CLASS = new TypeToken<List<Map<String, Object>>>(){}.getRawType();
    public static final Class<List<String>> STRING_LIST_CLASS = new TypeToken<List<String>>(){}.getRawType();
    protected static Pattern LIST_PATTERN = Pattern.compile("\\[(\\d+)\\]");

    public static <T> T deepRetrieve(Object map, String property) {
        Assertions.checkBool(!property.startsWith("."), "property cannot begin with a dot");
        if (!property.contains(".")) {
            return MapRetriever.mapGetOrReflect(map, property);
        }
        String[] parts = property.split("\\.");
        Object child = map;
        for (int i = 0; i < parts.length - 1; ++i) {
            if ((child = MapRetriever.mapGetOrReflect(child, parts[i])) != null) continue;
            return null;
        }
        return MapRetriever.mapGetOrReflect(child, parts[parts.length - 1]);
    }

    public static <T> T mapGetOrReflect(Object object, String property) {
        if (object instanceof List) {
            Matcher matcher = LIST_PATTERN.matcher(property);
            Assertions.checkBool(matcher.matches(), "property `" + property + "` not formatted as a [index]");
            return (T)((List)object).get(Integer.parseInt(matcher.group(1)));
        }
        if (object instanceof Map) {
            return (T)((Map)object).get(property);
        }
        Field field = ReflectionUtil.declaredField(object.getClass(), property);
        return field == null ? null : (T)ReflectionUtil.fieldValue(object, field);
    }

    public static <T> List<T> deepCollect(Map<String, Object> map, String property, Class<? super T> clazz) {
        Assertions.checkBool(!property.startsWith("."), "property cannot begin with a dot");
        if (!property.contains(".")) {
            Object val = map.get(property);
            return val == null ? ListBuilder.immutableList() : (val instanceof List ? (List)val : ListBuilder.immutableList(val));
        }
        ListBuilder.ImmutableListBuilder result = ListBuilder.immutableListBuilder();
        MapRetriever.walkProps(map, StrUtil.safePrefix(property, "."), StrUtil.safeSuffix(property, "."), result, clazz);
        return result.build();
    }

    private static <T> void walkProps(Map<String, Object> map, String prop, String remains, ListBuilder.ImmutableListBuilder<T> result, Class<? super T> clazz) {
        Pair<String, String> remainsPair;
        Object child = map.get(prop);
        if (remains.isEmpty()) {
            if (child instanceof Collection) {
                for (Object gc : (Collection)child) {
                    if (!ReflectionUtil.isAssignable(clazz, ReflectionUtil.safeClass(gc))) continue;
                    result.add(gc);
                }
            } else if (ReflectionUtil.isAssignable(clazz, ReflectionUtil.safeClass(child))) {
                result.add(child);
            }
            return;
        }
        Pair<String, String> pair = remainsPair = remains.contains(".") ? Pair.pair(StrUtil.safePrefix(remains, "."), StrUtil.safeSuffix(remains, ".")) : Pair.pair(remains, "");
        if (child instanceof Map) {
            MapRetriever.walkProps(MapRetriever.asMap(child), (String)remainsPair._a, (String)remainsPair._b, result, clazz);
        } else if (child instanceof Collection) {
            for (Object gc : (Collection)child) {
                MapRetriever.walkProps(MapRetriever.asMap(gc), (String)remainsPair._a, (String)remainsPair._b, result, clazz);
            }
        }
    }

    public static String optStr(Map<String, Object> map, String prop) {
        return MapRetriever.stringVal(map, prop, false, null);
    }

    public static String optStr(Map<String, Object> map, String prop, String defVal) {
        return MapRetriever.stringVal(map, prop, false, defVal);
    }

    public static String reqdStr(Map<String, Object> map, String prop) {
        return MapRetriever.stringVal(map, prop, true, null);
    }

    public static boolean boolVal(Map<String, Object> map, String prop, boolean defVal) {
        return MapRetriever.asValue(map, prop, Boolean.class, defVal);
    }

    public static int intVal(Map<String, Object> map, String prop, int defVal) {
        return MapRetriever.asValue(map, prop, Integer.class, defVal);
    }

    public static long longVal(Map<String, Object> map, String prop, long defVal) {
        return MapRetriever.asValue(map, prop, Long.class, defVal);
    }

    public static Long longStrVal(Map<String, Object> map, String prop) {
        Object value = map.get(prop);
        return value == null ? null : Long.valueOf(value instanceof Number ? ((Number)value).longValue() : Long.parseLong(String.valueOf(value)));
    }

    public static long longStrVal(Map<String, Object> map, String prop, long defaultValue) {
        Object value = map.get(prop);
        return value == null ? defaultValue : (value instanceof Number ? ((Number)value).longValue() : Long.parseLong(String.valueOf(value)));
    }

    public static String stringVal(Map<String, Object> map, String prop, boolean required, String defVal) {
        return (String)map.getOrDefault(required ? MapRetriever.reqdProp(map, prop) : prop, defVal);
    }

    public static List<Map<String, Object>> mapListVal(Map<String, Object> map, String prop) {
        return (List)MapRetriever.asValue(map, prop, List.class, ListBuilder.immutableList());
    }

    public static <T> List<T> listVal(Map<String, Object> map, String prop) {
        return (List)MapRetriever.asValue(map, prop, List.class, ListBuilder.immutableList());
    }

    public static MapResult resultVal(Map<String, Object> map, String prop) {
        Object result = map.get(prop);
        return result instanceof MapResult ? (MapResult)result : (result instanceof Map ? MapResult.immutableResult(MAP_CLASS.cast(result)) : MapResult.immutableResult());
    }

    public static Map<String, Object> mapVal(Map<String, Object> map, String prop) {
        return (Map)MapRetriever.asValue(map, prop, MAP_CLASS, MapBuilder.immutableMap());
    }

    public static <T> T asNullable(Map<String, Object> map, String prop, Class<T> clazz) {
        return clazz.cast(map.getOrDefault(prop, null));
    }

    public static <E extends Enum<E>> E enumValue(Map<String, Object> map, String prop, Class<E> enumClass) {
        Object obj = map.get(MapRetriever.reqdProp(map, prop));
        return (E)(obj instanceof String ? (Enum)EnumCache.fetchEnumValueFor(enumClass, (String)obj) : (Enum)enumClass.cast(obj));
    }

    public static <T> T optValue(Map<String, Object> map, String prop) {
        return (T)map.get(prop);
    }

    public static <T> T optValue(Map<String, Object> map, String prop, T defValue) {
        return (T)map.getOrDefault(prop, defValue);
    }

    public static <T> T reqdValue(Map<String, Object> map, String prop) {
        return (T)map.get(MapRetriever.reqdProp(map, prop));
    }

    public static <T> T asValue(Map<String, Object> map, String prop, Class<T> clazz, T defVal) {
        return clazz.cast(map.getOrDefault(prop, defVal));
    }

    public static String reqdProp(Map<String, Object> map, String prop) {
        return Assertions.checkContains(map, prop);
    }

    public static Map<String, Object> asMap(Object object) {
        return object == null ? MapBuilder.immutableMap() : MAP_CLASS.cast(object);
    }

    public static <T> T removeVal(Map<String, Object> map, String prop) {
        return (T)map.remove(MapRetriever.reqdProp(map, prop));
    }

    public static <T> T removeIfExists(Map<String, Object> map, String prop) {
        return MapRetriever.removeIfExists(map, prop, null);
    }

    public static <T> T removeIfExists(Map<String, Object> map, String prop, T defVl) {
        return (T)(map.containsKey(prop) ? map.remove(prop) : defVl);
    }
}

