/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.Builder;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.UrnUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;

public final class Subject {
    public final String username;
    public final List<String> roles;
    public final MapResult metadata;
    public final boolean enabled;
    @Nullable
    public final String fullName;
    @Nullable
    public final String email;

    private Subject() {
        this(null, (List<String>)ListBuilder.immutableList(), MapResult.immutableResult(), true, null, null);
    }

    public static Subject buildWith(Map<String, Object> map) {
        return (Subject)io.polyglotted.common.model.Builder.buildWith(map, Builder.class);
    }

    public static Builder subjectBuilder() {
        return new Builder();
    }

    public Subject(String username, List<String> roles, MapResult metadata, boolean enabled, @Nullable String fullName, @Nullable String email) {
        this.username = username;
        this.roles = roles;
        this.metadata = metadata;
        this.enabled = enabled;
        this.fullName = fullName;
        this.email = email;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject other = (Subject)o;
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        List<String> this$roles = this.roles;
        List<String> other$roles = other.roles;
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        MapResult this$metadata = this.metadata;
        MapResult other$metadata = other.metadata;
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        String this$fullName = this.fullName;
        String other$fullName = other.fullName;
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$email = this.email;
        String other$email = other.email;
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        List<String> $roles = this.roles;
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        MapResult $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        result = result * 59 + (this.enabled ? 79 : 97);
        String $fullName = this.fullName;
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $email = this.email;
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    public String toString() {
        return "Subject(username=" + this.username + ", roles=" + this.roles + ", metadata=" + this.metadata + ", enabled=" + this.enabled + ", fullName=" + this.fullName + ", email=" + this.email + ")";
    }

    public static class Builder
    implements io.polyglotted.common.model.Builder<Subject> {
        private String username;
        private final ListBuilder.ImmutableListBuilder<String> roles = ListBuilder.immutableListBuilder();
        private final MapBuilder.ImmutableMapBuilder<String, Object> metadata = MapResult.immutableResultBuilder();
        private boolean enabled = true;
        @Builder.Name(value="full_name")
        private String fullName;
        private String email;

        public Builder usernameMd5(Object ... parts) {
            return this.username(DigestUtils.md5Hex((String)UrnUtil.safeUrnOf(parts)));
        }

        public Builder role(String role) {
            this.roles.add(role);
            return this;
        }

        public Builder roles(Iterable<String> roles) {
            this.roles.addAll(roles);
            return this;
        }

        public Builder metadata(String key, Object value) {
            this.metadata.put((Object)key, value);
            return this;
        }

        public Builder metadata(Map<String, Object> meta) {
            this.metadata.putAll((Map)meta);
            return this;
        }

        @Override
        public Subject build() {
            return new Subject(Objects.requireNonNull(this.username, "username"), (List<String>)this.roles.build(), this.metadata.immutable(), this.enabled, this.fullName, this.email);
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        private Builder() {
        }
    }
}

