/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Strings;
import io.polyglotted.common.model.GeoPoint;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.DateFormatters;
import io.polyglotted.common.util.Sanitizer;
import java.io.IOException;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

public abstract class Serializers {
    public static SimpleModule baseModule() {
        SimpleModule module = new SimpleModule("BaseSerializer");
        module.addAbstractTypeMapping(MapResult.class, MapResult.SimpleMapResult.class);
        module.addSerializer(Double.TYPE, (JsonSerializer)new DoubleSerializer());
        module.addSerializer(GeoPoint.class, new ToStringSerializer());
        module.addSerializer(InetAddress.class, (JsonSerializer)new IpSerializer());
        module.addSerializer(LocalDate.class, new ToStringSerializer());
        module.addSerializer(LocalDateTime.class, new ToStringSerializer());
        module.addSerializer(LocalTime.class, new ToStringSerializer());
        module.addSerializer(OffsetDateTime.class, new ToStringSerializer());
        module.addSerializer(OffsetTime.class, new ToStringSerializer());
        module.addSerializer(ZonedDateTime.class, new ToStringSerializer());
        module.addDeserializer(LocalDate.class, new SanitizeSerializer<LocalDate>(LocalDate.class));
        module.addDeserializer(LocalDateTime.class, new SanitizeSerializer<LocalDateTime>(LocalDateTime.class));
        module.addDeserializer(LocalTime.class, new SanitizeSerializer<LocalTime>(LocalTime.class));
        module.addDeserializer(Long.TYPE, (JsonDeserializer)new DateLongSerializer(Long.TYPE, 0L));
        module.addDeserializer(Long.class, (JsonDeserializer)new DateLongSerializer(Long.class, null));
        module.addDeserializer(OffsetDateTime.class, new SanitizeSerializer<OffsetDateTime>(OffsetDateTime.class));
        module.addDeserializer(OffsetTime.class, new SanitizeSerializer<OffsetTime>(OffsetTime.class));
        module.addDeserializer(String.class, (JsonDeserializer)new StdStringSerializer());
        module.addDeserializer(ZonedDateTime.class, new SanitizeSerializer<ZonedDateTime>(ZonedDateTime.class));
        return module;
    }

    private static class SanitizeSerializer<T>
    extends StdDeserializer<T> {
        SanitizeSerializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String result = StringDeserializer.instance.deserialize(p, ctxt);
            return (T)(Strings.isNullOrEmpty((String)result) ? null : Sanitizer.sanitize(this._valueClass, result));
        }
    }

    private static class DateLongSerializer
    extends StdDeserializer<Long> {
        private final NumberDeserializers.LongDeserializer backoff;

        DateLongSerializer(Class<Long> vc, Long nvl) {
            super(vc);
            this.backoff = new NumberDeserializers.LongDeserializer(vc, nvl);
        }

        public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String value;
            if (p.getCurrentTokenId() == 6 && (value = p.getText().trim()).length() > 0) {
                try {
                    return DateFormatters.parseDateTime(value).toInstant().toEpochMilli();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            return this.backoff.deserialize(p, ctxt);
        }
    }

    public static class IpSerializer
    extends JsonSerializer<InetAddress> {
        public void serialize(InetAddress src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src != null) {
                gen.writeString(src.getHostAddress());
            }
        }
    }

    private static class ToStringSerializer<T>
    extends JsonSerializer<T> {
        private ToStringSerializer() {
        }

        public void serialize(T src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src != null) {
                gen.writeString(src.toString());
            }
        }
    }

    private static class StdStringSerializer
    extends StdDeserializer<String> {
        StdStringSerializer() {
            super(String.class);
        }

        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String result = StringDeserializer.instance.deserialize(p, ctxt);
            return Strings.isNullOrEmpty((String)result) ? null : result;
        }
    }

    private static class DoubleSerializer
    extends JsonSerializer<Double> {
        private DoubleSerializer() {
        }

        public void serialize(Double src, JsonGenerator gen, SerializerProvider prov) throws IOException {
            if (src == (double)src.longValue()) {
                gen.writeNumber(src.longValue());
            } else {
                gen.writeNumber(src.doubleValue());
            }
        }
    }
}

