/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.security;

import io.polyglotted.common.util.NullUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
@Order(value=-2147483648)
public class SimpleCorsFilter
extends GenericFilterBean {
    @Value(value="${spring.cors.headers:Authorization, Cache-Control, Content-Type, DNT, If-Modified-Since, Keep-Alive, User-Agent, X-Requested-With, X-Proxy-User, X-Session-Token, X-Realm, X-Real-IP, X-Forwarded-For}")
    private String corsHeaders = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        String allowOrigin = (String)NullUtil.nonNull((Object)httpReq.getHeader("X-REALM"), (Object)(request.getRemoteHost() + ":" + request.getRemotePort()));
        httpRes.setHeader("Access-Control-Allow-Origin", "http://" + allowOrigin);
        httpRes.setHeader("Access-Control-Allow-Methods", "DELETE, GET, HEAD, OPTIONS, POST, PUT");
        httpRes.setHeader("Access-Control-Allow-Headers", this.corsHeaders);
        httpRes.setHeader("Access-Control-Allow-Credentials", "true");
        httpRes.setHeader("Access-Control-Max-Age", "3600");
        chain.doFilter(request, response);
    }
}

