/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.security;

import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.spring.cognito.CognitoAuthFilter;
import io.polyglotted.spring.cognito.CognitoProcessor;
import io.polyglotted.spring.elastic.ElasticAuthFilter;
import io.polyglotted.spring.elastic.ElasticProcessor;
import io.polyglotted.spring.security.DefaultAuthProvider;
import io.polyglotted.spring.security.RestAuthEntryPoint;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true)
public class DefaultSecurityConfigurer
extends WebSecurityConfigurerAdapter {
    @Autowired
    private final DefaultAuthProvider defaultAuthProvider = null;
    @Autowired
    private CognitoProcessor cognitoProcessor = null;
    @Autowired
    private ElasticProcessor elasticProcessor = null;
    @Autowired
    private RestAuthEntryPoint restAuthEntryPoint = null;
    @Value(value="#{'${spring.authorised.endpoints:/api/**}'.split(',')}")
    private List<String> authorisedEndpoints = ListBuilder.immutableList();
    @Value(value="#{'${spring.unauthorised.endpoints}'.split(',')}")
    private List<String> unauthorisedEndpoints = ListBuilder.immutableList();
    @Value(value="#{'${spring.cors.headers:Authorization,Cache-Control,Content-Type,DNT,If-Modified-Since,Keep-Alive,User-Agent,X-Requested-With,X-Proxy-User,X-Session-Token,X-Realm,X-Real-IP,X-Forwarded-For}'.split(',')}")
    private List<String> corsHeaders = ListBuilder.immutableList();

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.defaultAuthProvider);
    }

    public void configure(WebSecurity web) throws Exception {
        super.configure(web);
        web.httpFirewall(this.httpFirewall());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.httpBasic().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.restAuthEntryPoint).and()).authorizeRequests().antMatchers(StringUtils.toStringArray(this.unauthorisedEndpoints))).permitAll().antMatchers(StringUtils.toStringArray(this.authorisedEndpoints))).authenticated().anyRequest()).authenticated().and()).addFilterBefore((Filter)new CognitoAuthFilter(this.cognitoProcessor), BasicAuthenticationFilter.class).addFilterBefore((Filter)new ElasticAuthFilter(this.elasticProcessor), BasicAuthenticationFilter.class).formLogin();
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins((List)ListBuilder.immutableList((Object[])new String[]{"*"}));
        configuration.setAllowedMethods((List)ListBuilder.immutableList((Object[])new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"}));
        configuration.setAllowedHeaders(this.corsHeaders);
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setMaxAge(Long.valueOf(3600L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    public HttpFirewall httpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        firewall.setAllowUrlEncodedPercent(true);
        firewall.setAllowUrlEncodedPeriod(true);
        return firewall;
    }
}

