/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.errorhandling;

import org.springframework.http.HttpStatus;
import org.unbescape.html.HtmlEscape;

public abstract class ExceptionFactory {
    public static <T> T checkNotFound(T t, String message) {
        if (t == null) {
            throw new NotFoundException(message);
        }
        return t;
    }

    public static NotFoundException notFoundException(String message) {
        return new NotFoundException(message);
    }

    public static WebException asInternalServerException(Throwable ex) {
        return ex.getCause() instanceof WebException ? (WebException)ex.getCause() : new WebException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), ex);
    }

    public static WebException internalServerException(String message, Throwable ex) {
        return new WebException(HttpStatus.INTERNAL_SERVER_ERROR, message, ex);
    }

    public static WebException internalServerException(String message) {
        return new WebException(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static WebException badRequestException(String message) {
        return new WebException(HttpStatus.BAD_REQUEST, message);
    }

    public static WebException forbiddenException(String message) {
        return new WebException(HttpStatus.FORBIDDEN, message);
    }

    public static WebException unauthorisedException(String message) {
        return new WebException(HttpStatus.UNAUTHORIZED, message);
    }

    public static WebException conflictException(String message) {
        return new WebException(HttpStatus.CONFLICT, message);
    }

    public static WebException tooManyException(String message) {
        return new WebException(HttpStatus.TOO_MANY_REQUESTS, message);
    }

    public static void checkBadRequest(boolean condition, String message) {
        ExceptionFactory.checkBadRequest(condition, message, null);
    }

    public static <T> T checkBadRequest(boolean condition, String message, T r) {
        if (!condition) {
            throw ExceptionFactory.badRequestException(message);
        }
        return r;
    }

    public static class WebException
    extends RuntimeException {
        public final HttpStatus status;

        public WebException(HttpStatus status, String message) {
            this(status, message, null);
        }

        public WebException(HttpStatus status, String message, Throwable cause) {
            super(HtmlEscape.escapeHtml4((String)message), cause);
            this.status = status;
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        private NotFoundException(String message) {
            super(message);
        }
    }
}

