/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.cognito;

import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProvider;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.GetUserRequest;
import com.amazonaws.services.cognitoidp.model.GetUserResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.Subject;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.spring.cognito.AbstractCognito;
import io.polyglotted.spring.cognito.CognitoAuthFilter;
import io.polyglotted.spring.security.DefaultAuthToken;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class CognitoProcessor
extends AbstractCognito {
    private static final Logger log = LoggerFactory.getLogger(CognitoProcessor.class);
    @Autowired
    private ObjectMapper objectMapper = null;

    @Autowired
    public CognitoProcessor(AbstractCognito.CognitoConfig config, AWSCognitoIdentityProvider cognitoClient) {
        super(config, cognitoClient);
    }

    DefaultAuthToken authenticate(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer")) {
            String bearerToken = header.substring(7);
            List<String> roles = this.fetchRoles(bearerToken);
            return new DefaultAuthToken(this.getUser(bearerToken).roles(roles).build(), bearerToken, CognitoProcessor.authorities(roles));
        }
        log.trace("No Bearer token found in HTTP Authorization header");
        return null;
    }

    private Subject.Builder getUser(String accessToken) {
        GetUserResult user = this.cognitoClient.getUser(new GetUserRequest().withAccessToken(accessToken));
        MapResult attributes = MapResult.simpleResult();
        for (AttributeType type : user.getUserAttributes()) {
            attributes.put((Object)type.getName().toLowerCase(Locale.ENGLISH), (Object)type.getValue());
        }
        return Subject.subjectBuilder().username((String)attributes.removeVal("sub")).email(attributes.optStr("email")).fullName(attributes.optStr("name")).metadata((Map)attributes);
    }

    private List<String> fetchRoles(String token) {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new CognitoAuthFilter.NotCognitoException("invalid token parts");
        }
        return CognitoProcessor.rolesFrom(BaseSerializer.deserialize((ObjectMapper)this.objectMapper, (byte[])Base64.decodeBase64((String)parts[1])));
    }

    private static List<String> rolesFrom(MapResult map) {
        return CollUtil.transformList((List)MapRetriever.listVal((Map)map, (String)"cognito:groups"), CognitoProcessor::groupToRole);
    }

    private static String groupToRole(String group) {
        return group.startsWith("ABACI_") ? group.substring(6) : group;
    }

    private static List<GrantedAuthority> authorities(List<String> roles) {
        return CollUtil.transformList(roles, role -> new SimpleGrantedAuthority("ROLE_" + role.toUpperCase()));
    }
}

