/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.elastic;

import io.polyglotted.common.model.AuthToken;
import io.polyglotted.common.model.Subject;
import io.polyglotted.common.util.CollUtil;
import io.polyglotted.common.util.HttpRequestBuilder;
import io.polyglotted.common.util.HttpUtil;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.spring.elastic.ElasticAuthFilter;
import io.polyglotted.spring.errorhandling.ExceptionFactory;
import io.polyglotted.spring.security.DefaultAuthToken;
import io.polyglotted.spring.web.SimpleResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class ElasticProcessor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ElasticProcessor.class);
    private static final String LOGIN_TEMPL = "{\"grant_type\":\"password\",\"username\":\"$userid\",\"password\":\"$passwd\"}";
    private static final String LOGOUT_TEMPL = "{\"token\":\"$token\"}";
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build()).build();
    @Value(value="${idp.elastic.url:http://localhost:9200}")
    private String baseUri = null;

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.httpClient.close();
    }

    public AuthToken login(String userId, String password) {
        ExceptionFactory.checkBadRequest(StrUtil.notNullOrEmpty((String)userId) && StrUtil.notNullOrEmpty((String)password), "Invalid credentials.");
        try {
            return AuthToken.buildWith((Map)HttpUtil.execute((HttpClient)this.httpClient, (HttpRequestBuilder)HttpUtil.buildPost((String)this.baseUri, (String)"/_xpack/security/oauth2/token").withBasicAuth(userId, password).withJson(LOGIN_TEMPL.replace("$userid", userId).replace("$passwd", password))));
        }
        catch (Exception ex) {
            log.debug("not found or invalid creds: {}", (Object)userId);
            throw ExceptionFactory.unauthorisedException(StrUtil.safePrefix((String)ex.getMessage(), (String)" ("));
        }
    }

    public SimpleResponse logout(String token) {
        try {
            HttpUtil.execute((HttpClient)this.httpClient, (HttpRequestBuilder)HttpUtil.buildDelete((String)this.baseUri, (String)"/_xpack/security/oauth2/token").withBearerAuth(token).withJson(LOGOUT_TEMPL.replace("$token", token)));
        }
        catch (Exception ex) {
            log.warn("failed to logout " + token);
        }
        return new SimpleResponse("logged-out");
    }

    DefaultAuthToken authenticate(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header != null) {
            if (header.startsWith("Basic") || header.startsWith("Bearer") && !header.contains(".")) {
                Subject subject = this.authenticateInternal(header);
                return new DefaultAuthToken(subject, header, ElasticProcessor.authorities(subject.roles));
            }
            log.trace("no Bearer token or Basic Auth found in AUTHORISATION header");
        }
        log.trace("AUTHORISATION header not found");
        return null;
    }

    private Subject authenticateInternal(String authHeader) {
        try {
            return Subject.buildWith((Map)HttpUtil.execute((HttpClient)this.httpClient, (HttpRequestBuilder)HttpUtil.buildGet((String)this.baseUri, (String)"/_xpack/security/_authenticate").withAuth(authHeader)));
        }
        catch (Exception ex) {
            throw new ElasticAuthFilter.ElasticClientException("failed to authenticate");
        }
    }

    private static List<GrantedAuthority> authorities(List<String> roles) {
        return (List)ListBuilder.immutableListBuilder().add((Object)new SimpleGrantedAuthority("ROLE_CONSUMER")).add((Object)new SimpleGrantedAuthority("ROLE_CURATOR")).addAll((Iterable)CollUtil.transformList(roles, role -> new SimpleGrantedAuthority("ROLE_" + role.toUpperCase()))).build();
    }
}

