/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.elastic;

import io.polyglotted.spring.elastic.ElasticProcessor;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class ElasticAuthFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ElasticAuthFilter.class);
    private final ElasticProcessor elasticProcessor;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SecurityContext context = SecurityContextHolder.getContext();
        Object authentication = context.getAuthentication();
        if (authentication == null) {
            try {
                authentication = this.elasticProcessor.authenticate(request);
                if (authentication != null) {
                    context.setAuthentication(authentication);
                }
            }
            catch (ElasticClientException ignored) {
                SecurityContextHolder.clearContext();
            }
            catch (Exception ex) {
                log.error("Unknown Error processing Bearer token", (Throwable)ex);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public ElasticAuthFilter(ElasticProcessor elasticProcessor) {
        this.elasticProcessor = elasticProcessor;
    }

    public static class ElasticClientException
    extends RuntimeException {
        ElasticClientException(String message) {
            super(message);
        }
    }
}

