/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.spring.cognito;

import com.amazonaws.services.cognitoidp.model.AWSCognitoIdentityProviderException;
import io.polyglotted.spring.cognito.CognitoProcessor;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class CognitoAuthFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CognitoAuthFilter.class);
    private final CognitoProcessor cognitoProcessor;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SecurityContext context = SecurityContextHolder.getContext();
        Object authentication = context.getAuthentication();
        if (authentication == null) {
            try {
                authentication = this.cognitoProcessor.authenticate(request);
                if (authentication != null) {
                    context.setAuthentication(authentication);
                }
            }
            catch (NotCognitoException notCognitoException) {
            }
            catch (AWSCognitoIdentityProviderException ignored) {
                SecurityContextHolder.clearContext();
            }
            catch (Exception ex) {
                log.error("Unknown Error processing Bearer token", (Throwable)ex);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public CognitoAuthFilter(CognitoProcessor cognitoProcessor) {
        this.cognitoProcessor = cognitoProcessor;
    }

    static class NotCognitoException
    extends RuntimeException {
        NotCognitoException(String message) {
            super(message);
        }
    }
}

