/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.applauncher.server;

import io.polyglotted.applauncher.server.Server;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(SpringServer.class);
    private final Class<?>[] configurationClasses;
    private AnnotationConfigApplicationContext applicationContext;
    private final CountDownLatch latch = new CountDownLatch(1);

    public SpringServer() {
        this(SpringServer.defaultConfigurationClasses());
    }

    @Override
    public void start() {
        this.applicationContext = new AnnotationConfigApplicationContext();
        this.applicationContext.register((Class[])this.configurationClasses);
        this.applicationContext.refresh();
        this.applicationContext.start();
        new Thread(this::awaitLatch).start();
        log.info("Server started");
    }

    private void awaitLatch() {
        this.latch.await();
    }

    @Override
    public void stop() {
        this.applicationContext.close();
        this.latch.countDown();
    }

    private static Class<?>[] defaultConfigurationClasses() {
        return new Class[]{Class.forName("applauncher.spring.MainConfiguration")};
    }

    public SpringServer(Class<?>[] configurationClasses) {
        this.configurationClasses = configurationClasses;
    }
}

