/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.polyglotted.applauncher.settings.SettingsHolder;
import io.polyglotted.common.es.ElasticClient;
import io.polyglotted.common.es.discovery.Ec2HostsProvider;
import io.polyglotted.common.es.transport.EsTransportClient;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportConnector {
    private static final Logger log = LoggerFactory.getLogger(TransportConnector.class);
    private static final Setting<Integer> TRANSPORT_PORT_SETTING = Setting.intSetting((String)"transport.tcp.port", (int)9300, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    private static final Setting<List<String>> MASTER_NODES = Setting.listSetting((String)"master.nodes", (List)Lists.newArrayList((Object[])new String[]{"localhost"}), String::toString, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<String> EC2_DISCOVERY = new Setting("discovery.type", "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    private static final Setting<String> EC2_HOST_PROVIDER = new Setting("discovery.zen.hosts_provider", EC2_DISCOVERY, s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope});

    public static ElasticClient transportClient(SettingsHolder settingsHolder) {
        Settings settings = Ec2HostsProvider.buildSettings((SettingsHolder)Preconditions.checkNotNull((Object)settingsHolder));
        List<String> masterNodes = (EC2_DISCOVERY.exists(settings) || EC2_HOST_PROVIDER.exists(settings)) && "ec2".equals(EC2_HOST_PROVIDER.get(settings)) ? Ec2HostsProvider.fetchEc2Addresses(settings) : (List<String>)MASTER_NODES.get(settings);
        return new EsTransportClient((Client)TransportConnector.createFrom(settingsHolder, settings, masterNodes));
    }

    private static TransportClient createFrom(SettingsHolder holder, Settings settings, List<String> masterNodes) throws IOException {
        PreBuiltTransportClient client = new PreBuiltTransportClient(TransportConnector.clientSettings(holder), new Class[0]);
        int port = (Integer)TRANSPORT_PORT_SETTING.get(settings);
        for (String node : masterNodes) {
            InetAddress hostName = InetAddress.getByName(node);
            log.debug("adding transport master node {}:{}", (Object)hostName, (Object)port);
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostName, port));
        }
        return client;
    }

    private static Settings clientSettings(SettingsHolder settingsHolder) {
        return Settings.builder().put("cluster.name", settingsHolder.stringValue("es.cluster.name")).put("client.transport.sniff", true).put("network.bind_host", 0).build();
    }
}

