/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.STSSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.common.collect.ImmutableMap;
import io.polyglotted.common.aws.AwsConfig;
import io.polyglotted.common.aws.ConfigCredentialsProvider;

public enum CredsProvider {
    CONFIG{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new ConfigCredentialsProvider(config);
        }
    }
    ,
    ENVIRONMENT{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new EnvironmentVariableCredentialsProvider();
        }
    }
    ,
    SYSTEM_PROPERTIES{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new SystemPropertiesCredentialsProvider();
        }
    }
    ,
    PROFILE{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new ProfileCredentialsProvider();
        }
    }
    ,
    CONTAINER{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new EC2ContainerCredentialsProviderWrapper();
        }
    }
    ,
    STS_ROLE{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.roleArn(), config.roleSessionName()).withStsClient((AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build()).build();
        }
    }
    ,
    STS_ROLE_PROXY{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.roleArn(), config.roleSessionName()).withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new ConfigCredentialsProvider(config))).build()).build();
        }
    }
    ,
    STS_SESSION{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSSessionCredentialsProvider((AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider());
        }
    }
    ,
    STS_SESSION_PROXY{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSSessionCredentialsProvider((AWSCredentialsProvider)new ConfigCredentialsProvider(config));
        }
    };

    private static final ImmutableMap<String, CredsProvider> INSTANCES;

    abstract AWSCredentialsProvider provider(AwsConfig var1);

    public static AWSCredentialsProvider getProvider(AwsConfig config) {
        return ((CredsProvider)((Object)INSTANCES.get((Object)config.provider()))).provider(config);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CredsProvider value : CredsProvider.values()) {
            builder.put((Object)value.name(), (Object)value).put((Object)value.name().toLowerCase(), (Object)value);
        }
        INSTANCES = builder.build();
    }
}

