/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.applauncher.crypto;

import java.util.UUID;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public final class CryptoClient {
    public static final String PASSWORD_SYSTEM_PROPERTY = "crypto.password";
    private static final String PREFIX = "ENC(";
    private static final String SUFFIX = ")";
    private final boolean supportEncryption;
    private final StringEncryptor encryptor;

    public CryptoClient() {
        this(CryptoClient.resolvePassword());
    }

    public CryptoClient(String password) {
        this(CryptoClient.notNullOrEmpty(password), CryptoClient.create(CryptoClient.notNullOrEmpty(password) ? password : UUID.randomUUID().toString()));
    }

    public String encrypt(String toEncrypt) {
        return this.supportEncryption && CryptoClient.notNullOrEmpty(toEncrypt) ? String.format("%s%s%s", PREFIX, this.encryptor.encrypt(toEncrypt), SUFFIX) : toEncrypt;
    }

    public String decrypt(String encrypted) {
        if (this.supportEncryption && CryptoClient.notNullOrEmpty(encrypted) && encrypted.startsWith(PREFIX) && encrypted.endsWith(SUFFIX)) {
            encrypted = encrypted.substring(PREFIX.length(), encrypted.length() - SUFFIX.length());
            return this.encryptor.decrypt(encrypted);
        }
        return encrypted;
    }

    private static String resolvePassword() {
        String password = System.getProperty(PASSWORD_SYSTEM_PROPERTY);
        return CryptoClient.notNullOrEmpty(password) ? password : System.getenv(PASSWORD_SYSTEM_PROPERTY);
    }

    private static StringEncryptor create(String password) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(password);
        encryptor.setAlgorithm("PBEWithMD5AndDES");
        return encryptor;
    }

    private static boolean notNullOrEmpty(String word) {
        return word != null && !"".equals(word);
    }

    private CryptoClient(boolean supportEncryption, StringEncryptor encryptor) {
        this.supportEncryption = supportEncryption;
        this.encryptor = encryptor;
    }
}

