/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.es.transport;

import com.google.common.collect.ImmutableMap;
import io.polyglotted.common.es.ElasticClient;
import io.polyglotted.common.es.ElasticException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.WritePipelineResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class EsTransportClient
implements ElasticClient {
    private final Client internalClient;

    @Override
    public void close() {
        this.internalClient.close();
    }

    @Override
    public boolean indexExists(String index) {
        try {
            return ((IndicesExistsResponse)this.internalClient.admin().indices().exists(new IndicesExistsRequest(new String[]{index})).actionGet()).isExists();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("indexExists failed", ex);
        }
    }

    @Override
    public boolean typeExists(String index, String ... types) {
        try {
            return ((TypesExistsResponse)this.internalClient.admin().indices().typesExists(new TypesExistsRequest(new String[]{index}, types)).actionGet()).isExists();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("typeExists failed", ex);
        }
    }

    @Override
    public Set<String> getIndices(String alias) {
        HashSet<String> indices = new HashSet<String>();
        Iterator indexIt = this.getMeta(alias).getIndices().keysIt();
        while (indexIt.hasNext()) {
            indices.add((String)indexIt.next());
        }
        return indices;
    }

    @Override
    public String getIndexMeta(String ... indices) {
        MetaData indexMetaDatas = this.getMeta(indices);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startArray();
        ImmutableOpenMap getIndices = indexMetaDatas.getIndices();
        Iterator indexIt = getIndices.keysIt();
        while (indexIt.hasNext()) {
            String index = (String)indexIt.next();
            IndexMetaData metaData = (IndexMetaData)getIndices.get((Object)index);
            builder.startObject();
            builder.startObject(index);
            builder.startObject("aliases");
            ImmutableOpenMap aliases = metaData.getAliases();
            Iterator aIt = aliases.keysIt();
            while (aIt.hasNext()) {
                AliasMetaData alias = (AliasMetaData)aliases.get(aIt.next());
                AliasMetaData.Builder.toXContent((AliasMetaData)alias, (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.startObject("mappings");
            ImmutableOpenMap mappings = metaData.getMappings();
            Iterator mIt = mappings.keysIt();
            while (mIt.hasNext()) {
                String type = (String)mIt.next();
                builder.field(type).map(((MappingMetaData)mappings.get((Object)type)).getSourceAsMap());
            }
            builder.endObject();
            builder.startObject("settings");
            Settings settings = metaData.getSettings();
            settings.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            builder.endObject();
            builder.endObject();
        }
        builder.endArray();
        return builder.string();
    }

    @Override
    public String getSettings(String ... indices) {
        MetaData indexMetaDatas = this.getMeta(indices);
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        ImmutableOpenMap getIndices = indexMetaDatas.getIndices();
        Iterator indexIt = getIndices.keysIt();
        while (indexIt.hasNext()) {
            String index = (String)indexIt.next();
            IndexMetaData metaData = (IndexMetaData)getIndices.get((Object)index);
            builder.startObject(index).startObject("settings");
            Settings settings = metaData.getSettings();
            settings.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject().endObject();
        }
        builder.endObject();
        return builder.string();
    }

    @Override
    public String getMapping(String index, String type) {
        ImmutableOpenMap getIndices = this.getMeta(index).getIndices();
        Iterator indexIt = getIndices.keysIt();
        while (indexIt.hasNext()) {
            ImmutableOpenMap mappings = ((IndexMetaData)getIndices.get(indexIt.next())).getMappings();
            Iterator mIt = mappings.keysIt();
            while (mIt.hasNext()) {
                if (!type.equals(mIt.next())) continue;
                return ((MappingMetaData)mappings.get((Object)type)).source().string();
            }
        }
        return null;
    }

    private MetaData getMeta(String ... indices) {
        try {
            return ((ClusterStateResponse)this.internalClient.admin().cluster().prepareState().setIndices(indices).execute().actionGet()).getState().metaData();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("getMeta failed", ex);
        }
    }

    @Override
    public void createIndex(CreateIndexRequest request) {
        try {
            ElasticException.checkState(((CreateIndexResponse)this.internalClient.admin().indices().create(request).actionGet()).isAcknowledged(), "unable to create index for " + request.index());
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("createIndex failed", ex);
        }
    }

    @Override
    public void updateAlias(IndicesAliasesRequest request) {
        try {
            ElasticException.checkState(((IndicesAliasesResponse)this.internalClient.admin().indices().aliases(request).actionGet()).isAcknowledged(), "unable to update aliases");
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("updateAlias failed", ex);
        }
    }

    @Override
    public void updateSettings(UpdateSettingsRequest request) {
        try {
            ElasticException.checkState(((UpdateSettingsResponse)this.internalClient.admin().indices().updateSettings(request).actionGet()).isAcknowledged(), "unable to update settings");
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("updateSettings failed", ex);
        }
    }

    @Override
    public void putMapping(PutMappingRequest request) {
        try {
            ElasticException.checkState(((PutMappingResponse)this.internalClient.admin().indices().putMapping(request).actionGet()).isAcknowledged(), "could not put mapping for " + request.type());
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("putMapping failed", ex);
        }
    }

    @Override
    public void forceRefresh(String ... indices) {
        try {
            this.internalClient.admin().indices().refresh(Requests.refreshRequest((String[])indices)).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("refresh failed", ex);
        }
    }

    @Override
    public void dropIndex(String ... indices) {
        try {
            ElasticException.checkState(((DeleteIndexResponse)this.internalClient.admin().indices().delete(new DeleteIndexRequest(indices).indicesOptions(IndicesOptions.lenientExpandOpen())).actionGet()).isAcknowledged(), "Could not clear one or more index " + Arrays.toString(indices));
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("dropIndex failed", ex);
        }
    }

    @Override
    public void waitForStatus(String status) {
        try {
            ClusterHealthResponse clusterHealth = (ClusterHealthResponse)this.internalClient.admin().cluster().prepareHealth(new String[0]).setWaitForNoRelocatingShards(true).setWaitForStatus(ClusterHealthStatus.fromString((String)status)).execute().actionGet();
            ElasticException.checkState(clusterHealth.getStatus() != ClusterHealthStatus.RED, "cluster has errors");
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("waitForStatus failed", ex);
        }
    }

    @Override
    public Map<String, Object> clusterHealth() {
        try {
            ClusterHealthResponse health = (ClusterHealthResponse)this.internalClient.admin().cluster().health(new ClusterHealthRequest()).actionGet();
            return ImmutableMap.builder().put((Object)"cluster_name", (Object)health.getClusterName()).put((Object)"status", (Object)health.getStatus().name().toLowerCase(Locale.ROOT)).put((Object)"timed_out", (Object)health.isTimedOut()).put((Object)"number_of_nodes", (Object)health.getNumberOfNodes()).put((Object)"number_of_data_nodes", (Object)health.getNumberOfDataNodes()).put((Object)"active_primary_shards", (Object)health.getActivePrimaryShards()).put((Object)"active_shards", (Object)health.getActiveShards()).put((Object)"relocating_shards", (Object)health.getRelocatingShards()).put((Object)"initializing_shards", (Object)health.getInitializingShards()).put((Object)"unassigned_shards", (Object)health.getUnassignedShards()).put((Object)"delayed_unassigned_shards", (Object)health.getDelayedUnassignedShards()).put((Object)"number_of_pending_tasks", (Object)health.getNumberOfPendingTasks()).put((Object)"number_of_in_flight_fetch", (Object)health.getNumberOfInFlightFetch()).put((Object)"task_max_waiting_in_queue_millis", (Object)(health.getTaskMaxWaitingTime().millis() == 0L ? "-" : health.getTaskMaxWaitingTime().getStringRep())).put((Object)"active_shards_percent_as_number", (Object)String.format(Locale.ROOT, "%1.1f%%", health.getActiveShardsPercent())).build();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("clusterHealth failed", ex);
        }
    }

    @Override
    public void buildPipeline(String id, String json) {
        try {
            ElasticException.checkState(((WritePipelineResponse)this.internalClient.admin().cluster().preparePutPipeline(id, (BytesReference)new BytesArray(json), XContentType.JSON).execute().actionGet()).isAcknowledged(), "unable to build pipeline");
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("buildPipeline failed", ex);
        }
    }

    @Override
    public boolean pipelineExists(String id) {
        try {
            return ((GetPipelineResponse)this.internalClient.admin().cluster().prepareGetPipeline(new String[]{id}).execute().actionGet()).isFound();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("pipelineExists failed", ex);
        }
    }

    @Override
    public IndexResponse index(IndexRequest request) {
        try {
            return (IndexResponse)this.internalClient.index(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("index failed", ex);
        }
    }

    @Override
    public UpdateResponse update(UpdateRequest request) {
        try {
            return (UpdateResponse)this.internalClient.update(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("update failed", ex);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest request) {
        try {
            return (DeleteResponse)this.internalClient.delete(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("delete failed", ex);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest request) {
        try {
            return (BulkResponse)this.internalClient.bulk(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("bulk failed", ex);
        }
    }

    @Override
    public void bulkAsync(BulkRequest request, ActionListener<BulkResponse> listener) {
        try {
            this.internalClient.bulk(request, listener);
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("bulkAsync failed", ex);
        }
    }

    @Override
    public GetResponse get(GetRequest request) {
        try {
            return (GetResponse)this.internalClient.get(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("get failed", ex);
        }
    }

    @Override
    public MultiGetResponse multiGet(MultiGetRequest request) {
        try {
            return (MultiGetResponse)this.internalClient.multiGet(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("multiGet failed", ex);
        }
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        try {
            return (SearchResponse)this.internalClient.search(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("search failed", ex);
        }
    }

    @Override
    public SearchResponse searchScroll(SearchScrollRequest request) {
        try {
            return (SearchResponse)this.internalClient.searchScroll(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("searchScroll failed", ex);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        try {
            return (ClearScrollResponse)this.internalClient.clearScroll(request).actionGet();
        }
        catch (Exception ex) {
            throw ElasticException.handleEx("clearScroll failed", ex);
        }
    }

    public EsTransportClient(Client internalClient) {
        this.internalClient = internalClient;
    }
}

