/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.es.discovery;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import io.polyglotted.common.es.discovery.Ec2Service;
import java.util.Objects;
import java.util.Random;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Ec2ServiceImpl
implements Ec2Service {
    private static final Logger log = LoggerFactory.getLogger(Ec2ServiceImpl.class);

    Ec2ServiceImpl() {
    }

    static AmazonEC2 client(Settings settings) {
        Regions region = Regions.EU_WEST_1;
        if (REGION_SETTING.exists(settings) || Ec2Service.CLOUD_EC2.REGION_SETTING.exists(settings)) {
            region = Regions.fromName((String)((String)Ec2Service.CLOUD_EC2.REGION_SETTING.get(settings)));
        }
        return (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2Client.builder().withCredentials(Ec2ServiceImpl.buildCredentials(settings))).withClientConfiguration(Ec2ServiceImpl.buildConfiguration(settings))).withRegion(region)).build();
    }

    private static AWSCredentialsProvider buildCredentials(Settings settings) {
        DefaultAWSCredentialsProviderChain credentials;
        try (SecureString key = (SecureString)Ec2Service.DISCOVERY_EC2.ACCESS_KEY_SETTING.get(settings);
             SecureString secret = (SecureString)Ec2Service.DISCOVERY_EC2.SECRET_KEY_SETTING.get(settings);){
            if (key.length() == 0 && secret.length() == 0) {
                log.debug("Using either environment variables, system properties or instance profile credentials");
                credentials = new DefaultAWSCredentialsProviderChain();
            } else {
                log.debug("Using basic key/secret credentials");
                credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(key.toString(), secret.toString()));
            }
        }
        return credentials;
    }

    private static ClientConfiguration buildConfiguration(Settings settings) {
        String awsSigner;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol((Protocol)Ec2Service.DISCOVERY_EC2.PROTOCOL_SETTING.get(settings));
        if (PROXY_HOST_SETTING.exists(settings) || Ec2Service.DISCOVERY_EC2.PROXY_HOST_SETTING.exists(settings)) {
            String proxyHost = (String)Ec2Service.DISCOVERY_EC2.PROXY_HOST_SETTING.get(settings);
            Integer proxyPort = (Integer)Ec2Service.DISCOVERY_EC2.PROXY_PORT_SETTING.get(settings);
            try (SecureString proxyUsername = (SecureString)Ec2Service.DISCOVERY_EC2.PROXY_USERNAME_SETTING.get(settings);
                 SecureString proxyPassword = (SecureString)Ec2Service.DISCOVERY_EC2.PROXY_PASSWORD_SETTING.get(settings);){
                clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort.intValue()).withProxyUsername(proxyUsername.toString()).withProxyPassword(proxyPassword.toString());
            }
        }
        if (Strings.hasText((String)(awsSigner = (String)Ec2Service.CLOUD_EC2.SIGNER_SETTING.get(settings)))) {
            log.debug("using AWS API signer [{}]", (Object)awsSigner);
            Ec2ServiceImpl.configureSigner(awsSigner, clientConfiguration);
        }
        Random rand = Randomness.get();
        RetryPolicy retryPolicy = new RetryPolicy(RetryPolicy.RetryCondition.NO_RETRY_CONDITION, (originalRequest, exception, retriesAttempted) -> {
            log.warn("EC2 API request failed, retry again. Reason was:", (Throwable)exception);
            return 1000L * (long)(10.0 * Math.pow(2.0, (double)retriesAttempted / 2.0) * (1.0 + rand.nextDouble()));
        }, 10, false);
        clientConfiguration.setRetryPolicy(retryPolicy);
        clientConfiguration.setSocketTimeout((int)((TimeValue)Ec2Service.DISCOVERY_EC2.READ_TIMEOUT_SETTING.get(settings)).millis());
        return clientConfiguration;
    }

    private static void configureSigner(String signer, ClientConfiguration configuration) {
        try {
            SignerFactory.getSignerByTypeAndService((String)Objects.requireNonNull(signer, "[null] signer set"), null);
        }
        catch (IllegalArgumentException e) {
            log.warn("wrong signer set {} {}", (Object)signer, (Object)e.getMessage());
        }
        configuration.setSignerOverride(signer);
    }
}

