/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.es;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.polyglotted.applauncher.settings.SettingsHolder;
import io.polyglotted.common.es.ElasticClient;
import io.polyglotted.common.es.rest.EsRestClient;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;

public class HighLevelConnector {
    public static ElasticClient highLevelClient(SettingsHolder settingsHolder) {
        return HighLevelConnector.highLevelClient(settingsHolder, "es");
    }

    public static ElasticClient highLevelClient(SettingsHolder settingsHolder, String prefix) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])HighLevelConnector.buildHosts(settingsHolder, prefix)).setMaxRetryTimeoutMillis(settingsHolder.intValue(prefix + ".max.retryTimeout.millis", 300000));
        HighLevelConnector.setCredentials(settingsHolder, builder, prefix);
        return settingsHolder.booleanValue(prefix + ".sniffer.enabled", false) ? HighLevelConnector.sniffingClient(builder) : new EsRestClient(builder.build(), null);
    }

    private static HttpHost[] buildHosts(SettingsHolder settingsHolder, String prefix) {
        int port = settingsHolder.intValue(prefix + ".http.port", 9200);
        String scheme = settingsHolder.stringValue(prefix + ".scheme", "http");
        Iterable masterNodes = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)settingsHolder.stringValue(prefix + ".master.nodes", "localhost"));
        return (HttpHost[])Iterables.toArray((Iterable)Iterables.transform((Iterable)masterNodes, node -> new HttpHost(Objects.requireNonNull(node), port, scheme)), HttpHost.class);
    }

    private static void setCredentials(SettingsHolder settingsHolder, RestClientBuilder builder, String prefix) {
        String userName = settingsHolder.stringValue(prefix + ".auth.username", null);
        String password = settingsHolder.stringValue(prefix + ".auth.password", null);
        if (Objects.nonNull(userName) && Objects.nonNull(password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            builder.setHttpClientConfigCallback(arg_0 -> HighLevelConnector.lambda$setCredentials$1((CredentialsProvider)credentialsProvider, arg_0));
        }
    }

    private static EsRestClient sniffingClient(RestClientBuilder builder) {
        SniffOnFailureListener sniffOnFailureListener = new SniffOnFailureListener();
        RestClient restClient = builder.setFailureListener((RestClient.FailureListener)sniffOnFailureListener).build();
        Sniffer sniffer = Sniffer.builder((RestClient)restClient).setSniffAfterFailureDelayMillis(30000).build();
        sniffOnFailureListener.setSniffer(sniffer);
        return new EsRestClient(restClient, sniffer);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$setCredentials$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder callback) {
        return callback.setDefaultCredentialsProvider(credentialsProvider);
    }
}

