/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.aws;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.polyglotted.applauncher.settings.Attribute;
import io.polyglotted.applauncher.settings.Settings;
import io.polyglotted.common.aws.CredsProvider;

@Settings
public interface AwsConfig {
    public static final int MAX_MESSAGE_SIZE = 262144;

    @Attribute(name="aws.access_key")
    default public String accessKey() {
        return "";
    }

    @Attribute(name="aws.secret_key", encrypted=true)
    default public String secretKey() {
        return "";
    }

    @Attribute(name="aws.region")
    default public String region() {
        return "eu-west-1";
    }

    @Attribute(name="aws.provider")
    default public String provider() {
        return "environment";
    }

    @Attribute(name="aws.role_arn")
    default public String roleArn() {
        return "";
    }

    @Attribute(name="aws.role_session_name")
    default public String roleSessionName() {
        return "defaultSession";
    }

    public static AmazonS3 createS3Client(AwsConfig config) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(Regions.fromName((String)config.region()))).build();
    }

    public static AmazonS3Encryption s3EncryptionClient(AwsConfig config, String cmkId) {
        return (AmazonS3Encryption)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClient.encryptionBuilder().withCredentials(CredsProvider.getProvider(config))).withEncryptionMaterials((EncryptionMaterialsProvider)new KMSEncryptionMaterialsProvider(cmkId)).withCryptoConfiguration(new CryptoConfiguration().withAwsKmsRegion(RegionUtils.getRegion((String)config.region()))).withRegion(config.region())).build();
    }

    public static AmazonSQS createSqsClient(AwsConfig config) {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(Regions.fromName((String)config.region()))).build();
    }

    public static AmazonSNS createSnsClient(AwsConfig config) {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(Regions.fromName((String)config.region()))).build();
    }

    public static AWSSimpleSystemsManagement createSsmClient(AwsConfig config) {
        return (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(Regions.fromName((String)config.region()))).build();
    }
}

