/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public abstract class MapperUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
    private static final Class<Map<String, Object>> MAP_CLASS = new TypeToken<Map<String, Object>>(){}.getRawType();

    public static Map<String, Object> readToMap(String bytes) throws IOException {
        return (Map)MAPPER.readValue(bytes, MAP_CLASS);
    }

    public static String reqdStr(Map<String, Object> map, String key) {
        return Objects.requireNonNull((String)map.get(key), key + " is missing");
    }
}

