/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.es.rest;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import io.polyglotted.common.es.ElasticClient;
import io.polyglotted.common.es.ElasticException;
import io.polyglotted.common.util.MapperUtil;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.sniff.Sniffer;

public class EsRestClient
implements ElasticClient {
    private static final Joiner COMMA = Joiner.on((String)",");
    private final RestClient restClient;
    private final Sniffer sniffer;
    private final RestHighLevelClient internalClient;

    public EsRestClient(RestClient restClient, Sniffer sniffer) {
        this(restClient, sniffer, new RestHighLevelClient(restClient));
    }

    @Override
    public void close() throws Exception {
        if (this.sniffer != null) {
            this.sniffer.close();
        }
        this.restClient.close();
    }

    @Override
    public boolean indexExists(String index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean typeExists(String index, String ... types) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getIndices(String alias) {
        try {
            Map<String, Object> responseObject = MapperUtil.readToMap(this.performCliRequest("/" + alias + "/_aliases"));
            return ImmutableSet.copyOf(responseObject.keySet());
        }
        catch (Exception ioe) {
            throw ElasticException.handleEx("getIndices failed", ioe);
        }
    }

    @Override
    public String getIndexMeta(String ... indices) {
        try {
            return this.performCliRequest("/" + COMMA.join((Object[])indices) + "/");
        }
        catch (Exception ioe) {
            throw ElasticException.handleEx("getIndexMeta failed", ioe);
        }
    }

    @Override
    public String getSettings(String ... indices) {
        try {
            return this.performCliRequest("/" + COMMA.join((Object[])indices) + "/_settings");
        }
        catch (Exception e) {
            throw ElasticException.handleEx("getSettings failed", e);
        }
    }

    @Override
    public String getMapping(String index, String type) {
        try {
            return this.performCliRequest("/" + index + "/" + type + "/_mapping");
        }
        catch (Exception e) {
            throw ElasticException.handleEx("getSettings failed", e);
        }
    }

    @Override
    public void createIndex(CreateIndexRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAlias(IndicesAliasesRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSettings(UpdateSettingsRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putMapping(PutMappingRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceRefresh(String ... indices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropIndex(String ... indices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void waitForStatus(String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> clusterHealth() {
        try {
            return MapperUtil.readToMap(this.performCliRequest("/_cluster/health"));
        }
        catch (Exception ioe) {
            throw ElasticException.handleEx("clusterHealth failed", ioe);
        }
    }

    @Override
    public void buildPipeline(String id, String resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean pipelineExists(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexResponse index(IndexRequest request) {
        try {
            return this.internalClient.index(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("index failed", ioe);
        }
    }

    @Override
    public UpdateResponse update(UpdateRequest request) {
        try {
            return this.internalClient.update(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("update failed", ioe);
        }
    }

    @Override
    public DeleteResponse delete(DeleteRequest request) {
        try {
            return this.internalClient.delete(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("delete failed", ioe);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest request) {
        try {
            return this.internalClient.bulk(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("bulk failed", ioe);
        }
    }

    @Override
    public void bulkAsync(BulkRequest request, ActionListener<BulkResponse> listener) {
        try {
            this.internalClient.bulkAsync(request, listener, new Header[0]);
        }
        catch (Exception ioe) {
            throw new ElasticException("bulkAsync failed", ioe);
        }
    }

    @Override
    public GetResponse get(GetRequest request) {
        try {
            return this.internalClient.get(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("get failed", ioe);
        }
    }

    @Override
    public MultiGetResponse multiGet(MultiGetRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        try {
            return this.internalClient.search(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("search failed", ioe);
        }
    }

    @Override
    public SearchResponse searchScroll(SearchScrollRequest request) {
        try {
            return this.internalClient.searchScroll(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("searchScroll failed", ioe);
        }
    }

    @Override
    public ClearScrollResponse clearScroll(ClearScrollRequest request) {
        try {
            return this.internalClient.clearScroll(request, new Header[0]);
        }
        catch (IOException ioe) {
            throw new ElasticException("clearScroll failed", ioe);
        }
    }

    private String performCliRequest(String endpoint) throws IOException {
        Response response = this.restClient.performRequest("GET", endpoint, new Header[0]);
        int statusCode = response.getStatusLine().getStatusCode();
        ElasticException.checkState(statusCode >= 200 && statusCode < 300, response.getStatusLine().getReasonPhrase());
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    @ConstructorProperties(value={"restClient", "sniffer", "internalClient"})
    private EsRestClient(RestClient restClient, Sniffer sniffer, RestHighLevelClient internalClient) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.internalClient = internalClient;
    }
}

