/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.base.Preconditions;
import io.polyglotted.common.aws.AwsConfig;
import io.polyglotted.common.util.MapperUtil;
import java.io.IOException;
import java.io.InputStream;

public abstract class ObjectFetcher {
    public static ObjectMetadata fetchObjectMetadata(AwsConfig config, String bucket, String key) {
        return AwsConfig.createS3Client(config).getObjectMetadata(bucket, key);
    }

    public static S3Object fetchObject(AmazonS3 client, GetObjectRequest request) {
        return client.getObject(request);
    }

    public static InputStream fetchPartial(AwsConfig config, String bucket, String key, long[] range) {
        GetObjectRequest request = new GetObjectRequest(bucket, key);
        if (range != null) {
            request.setRange(range[0], range[1]);
        }
        return ObjectFetcher.fetchObject(AwsConfig.createS3Client(config), request).getObjectContent();
    }

    public static InputStream fetchSecure(AwsConfig config, String bucket, String key) throws IOException {
        return ObjectFetcher.fetchObject((AmazonS3)AwsConfig.s3EncryptionClient(config, ObjectFetcher.fetchCmkId(config, bucket, key)), new GetObjectRequest(bucket, key)).getObjectContent();
    }

    private static String fetchCmkId(AwsConfig config, String bucket, String key) throws IOException {
        ObjectMetadata metadata = ObjectFetcher.fetchObjectMetadata(config, bucket, key);
        String matDesc = (String)Preconditions.checkNotNull((Object)metadata.getUserMetaDataOf("x-amz-matdesc"), (Object)"missing material description");
        return MapperUtil.reqdStr(MapperUtil.readToMap(matDesc), "kms_cmk_id");
    }
}

