/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.polyglotted.applauncher.settings.Attribute;
import io.polyglotted.applauncher.settings.Settings;
import io.polyglotted.common.aws.AbaciCredentialsProviderChain;

@Settings
public interface AwsConfig {
    public static final int MAX_MESSAGE_SIZE = 262144;

    @Attribute(name="aws.access_key")
    default public String accessKey() {
        return "";
    }

    @Attribute(name="aws.secret_key", encrypted=true)
    default public String secretKey() {
        return "";
    }

    @Attribute(name="aws.region")
    default public String region() {
        return "eu-west-1";
    }

    public static AmazonSQS createSqsClient(AwsConfig config) {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AbaciCredentialsProviderChain(new AbaciCredentialsProviderChain.ConfigCredentialsProvider(config)))).withRegion(Regions.fromName((String)config.region()))).build();
    }

    public static AmazonSNS createSnsClient(AwsConfig config) {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AbaciCredentialsProviderChain(new AbaciCredentialsProviderChain.ConfigCredentialsProvider(config)))).withRegion(Regions.fromName((String)config.region()))).build();
    }
}

