/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.HttpRequestBuilder;
import io.polyglotted.common.util.MapRetriever;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static HttpRequestBuilder buildGet(String uri, String path, String auth) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.GET, uri, path).withAuth(auth);
    }

    public static HttpRequestBuilder buildPost(String uri, String path, String auth) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.POST, uri, path).withAuth(auth);
    }

    public static HttpRequestBuilder buildPut(String uri, String path, String auth) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.PUT, uri, path).withAuth(auth);
    }

    public static HttpRequestBuilder buildDelete(String uri, String path, String auth) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.DELETE, uri, path).withAuth(auth);
    }

    public static Map<String, Object> execute(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.execute(client, builder.request());
    }

    public static <H extends HttpRequestBase> Map<String, Object> execute(HttpClient client, H post) {
        return HttpUtil.execute(client, post, MapRetriever.MAP_CLASS);
    }

    public static <R> R execute(HttpClient client, HttpRequestBuilder builder, Class<R> clazz) {
        return HttpUtil.execute(client, builder.request(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <H extends HttpRequestBase, R> R execute(HttpClient client, H post, Class<R> clazz) {
        try {
            R r = BaseSerializer.deserialize(HttpUtil.executeRaw(client, post).getEntity().getContent(), clazz);
            return r;
        }
        finally {
            post.releaseConnection();
        }
    }

    public static String executePlain(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.executePlain(client, builder.request());
    }

    public static <H extends HttpRequestBase> String executePlain(HttpClient client, H post) {
        String string;
        try {
            string = CharStreams.toString((Readable)new InputStreamReader(HttpUtil.executeRaw(client, post).getEntity().getContent(), Charsets.UTF_8));
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return string;
    }

    public static HttpResponse executeRaw(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.executeRaw(client, builder.request());
    }

    public static <H extends HttpRequestBase> HttpResponse executeRaw(HttpClient client, H post) {
        HttpResponse httpResponse;
        try {
            httpResponse = HttpUtil.checkStatus(client.execute(post));
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return httpResponse;
    }

    private static HttpResponse checkStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!Assertions.checkBetween(statusCode, 200L, 300L, true, false)) {
            String errorMessage = CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8));
            log.warn(errorMessage);
            throw new HttpClientException(statusCode, errorMessage);
        }
        return response;
    }

    public static class HttpClientException
    extends RuntimeException {
        public final int errorCode;

        public HttpClientException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }
    }
}

