/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class EnumCache {
    private static final ConcurrentMap<Class<?>, Map<String, Object>> enumValuesMap = new ConcurrentHashMap();

    public static <E extends Enum> E fetchEnumFor(Class<E> enumClass, String value) {
        return (E)((Enum)EnumCache.fetchEnumValueFor(enumClass, value));
    }

    public static Object fetchEnumValueFor(Class enumClass, String value) {
        if (!enumValuesMap.containsKey(enumClass)) {
            EnumCache.putEnumValuesInMap(enumClass);
        }
        return ((Map)enumValuesMap.get(enumClass)).get(value);
    }

    private static <E extends Enum> void putEnumValuesInMap(Class<E> enumClass) {
        Preconditions.checkArgument((boolean)ReflectionUtil.isEnum(enumClass));
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            values.put((Object)value.name(), (Object)value);
            if (value.toString().equals(value.name())) continue;
            values.put((Object)value.toString(), (Object)value);
        }
        enumValuesMap.putIfAbsent(enumClass, (Map<String, Object>)values.build());
    }
}

