/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

abstract class SubscriberUtil {
    SubscriberUtil() {
    }

    static void stopThreadPool(ExecutorService threadPool, long time, TimeUnit unit) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(time, unit)) {
                threadPool.shutdownNow();
                threadPool.awaitTermination(time, unit);
            }
        }
        catch (InterruptedException var5) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static <T> T safeInvoke(Object object, String methodName, Class<?>[] paramClasses, Object ... params) {
        if (object == null) {
            return null;
        }
        try {
            Method method = object.getClass().getMethod(methodName, paramClasses);
            method.setAccessible(true);
            return (T)method.invoke(object, params);
        }
        catch (Exception e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
    }
}

