/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.polyglotted.aws.common.AwsClientFactory;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.aws.message.QueueConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsPublisher {
    private static final Logger log = LoggerFactory.getLogger(SqsPublisher.class);
    private final AmazonSQS sqsClient;

    public SqsPublisher(AwsConfig awsConfig) {
        this(AwsClientFactory.createSqsClient(awsConfig));
    }

    public void publish(QueueConfig config, String route, String json) {
        this.publish(config, route, json, null);
    }

    public void publish(QueueConfig config, String route, String json, String dedupeId) {
        if (json.length() > 262144) {
            log.error("sqs message exceeded max size: " + json);
            return;
        }
        if (!config.pattern().matcher(route).matches()) {
            return;
        }
        try {
            String queueUrl = this.sqsClient.getQueueUrl(config.getQueue()).getQueueUrl();
            this.sqsClient.sendMessage(new SendMessageRequest(queueUrl, json).withMessageGroupId(config.isFifo() ? route : null).withMessageDeduplicationId(dedupeId));
            log.info("published " + route + " on queue {}", (Object)queueUrl);
        }
        catch (Exception ex) {
            log.error("error publishing " + route + " on queue " + config.getQueue(), (Throwable)ex);
        }
    }

    public SqsPublisher(AmazonSQS sqsClient) {
        this.sqsClient = sqsClient;
    }
}

