/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import io.polyglotted.aws.message.QueueConfig;
import io.polyglotted.common.config.SettingsHolder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SqsConfig {
    private static final QueueConfig _DEFAULT = new QueueConfig().setEnabled(false);
    private List<QueueConfig> queueConfigs = new LinkedList<QueueConfig>();

    public QueueConfig findConfig(int index) {
        return index >= 0 && index < this.queueConfigs.size() ? this.queueConfigs.get(index) : _DEFAULT;
    }

    public QueueConfig findConfig(String name) {
        for (QueueConfig publisher : this.queueConfigs) {
            if (!name.equals(publisher.getName())) continue;
            return publisher;
        }
        return _DEFAULT;
    }

    public static SqsConfig sqsConfig(SettingsHolder holder, String prefix) {
        int qConfigs = holder.intValue(prefix + ".queueConfigs.count", 0);
        ArrayList<QueueConfig> configs = new ArrayList<QueueConfig>();
        for (int i = 0; i < qConfigs; ++i) {
            configs.add(QueueConfig.queueConfig(holder, prefix + ".queueConfigs." + i));
        }
        return new SqsConfig().setQueueConfigs(configs);
    }

    public List<QueueConfig> getQueueConfigs() {
        return this.queueConfigs;
    }

    public SqsConfig setQueueConfigs(List<QueueConfig> queueConfigs) {
        this.queueConfigs = queueConfigs;
        return this;
    }
}

