/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import com.amazonaws.services.sns.AmazonSNS;
import io.polyglotted.aws.common.AwsClientFactory;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.common.config.SettingsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnsPublisher {
    private static final Logger log = LoggerFactory.getLogger(SnsPublisher.class);
    private final AmazonSNS snsClient;

    public SnsPublisher(AwsConfig awsConfig) {
        this(AwsClientFactory.createSnsClient(awsConfig));
    }

    public void publish(SnsConfig snsConfig, String subject, String json) {
        if (json.length() > 262144) {
            log.warn("message exceeded max size: " + json);
            return;
        }
        try {
            this.snsClient.publish(snsConfig.getTopic(), json, subject);
            log.info("published notification on topic {}", (Object)snsConfig.getTopic());
        }
        catch (Exception ex) {
            log.error("error publishing sns on topic " + snsConfig.getTopic(), (Throwable)ex);
        }
    }

    public static SnsConfig snsConfig(SettingsHolder holder, String prefix) {
        return new SnsConfig().setEnabled(holder.booleanValue(prefix + ".enabled", false)).setTopic(holder.stringValue(prefix + ".topic", "_null"));
    }

    public SnsPublisher(AmazonSNS snsClient) {
        this.snsClient = snsClient;
    }

    public static class SnsConfig {
        private boolean enabled = true;
        private String topic = "";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getTopic() {
            return this.topic;
        }

        public SnsConfig setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SnsConfig setTopic(String topic) {
            this.topic = topic;
            return this;
        }
    }
}

