/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import io.polyglotted.common.config.SettingsHolder;
import java.util.regex.Pattern;

public class QueueConfig {
    private String name = "_default";
    private boolean enabled = true;
    private String queue = "";
    private boolean fifo = false;
    private String filter = ".*";
    private int maxMessages = 1;
    private int waitTimeInSeconds = 20;
    private long shutdownTimeInMillis = 100L;
    private transient Pattern _pattern;

    Pattern pattern() {
        return this._pattern != null ? this._pattern : (this._pattern = Pattern.compile(this.filter));
    }

    public static QueueConfig queueConfig(SettingsHolder holder, String prefix) {
        return new QueueConfig().setName(holder.stringValue(prefix + ".name", "_default")).setEnabled(holder.booleanValue(prefix + ".enabled", false)).setQueue(holder.stringValue(prefix + ".queue", "_none_")).setFifo(holder.booleanValue(prefix + ".fifo", false)).setFilter(holder.stringValue(prefix + ".filter", ".*")).setMaxMessages(holder.intValue(prefix + ".max_messages", 1)).setWaitTimeInSeconds(holder.intValue(prefix + ".wait_time_seconds", 20)).setShutdownTimeInMillis(holder.intValue(prefix + ".shutdown_time_millis", 100));
    }

    public String getName() {
        return this.name;
    }

    public QueueConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public QueueConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getQueue() {
        return this.queue;
    }

    public QueueConfig setQueue(String queue) {
        this.queue = queue;
        return this;
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public QueueConfig setFifo(boolean fifo) {
        this.fifo = fifo;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public QueueConfig setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public QueueConfig setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
        return this;
    }

    public int getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    public QueueConfig setWaitTimeInSeconds(int waitTimeInSeconds) {
        this.waitTimeInSeconds = waitTimeInSeconds;
        return this;
    }

    public long getShutdownTimeInMillis() {
        return this.shutdownTimeInMillis;
    }

    public QueueConfig setShutdownTimeInMillis(long shutdownTimeInMillis) {
        this.shutdownTimeInMillis = shutdownTimeInMillis;
        return this;
    }
}

