/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.message;

import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequestEntry;
import com.amazonaws.services.cloudwatchevents.model.PutEventsResult;
import io.polyglotted.aws.common.AwsClientFactory;
import io.polyglotted.aws.config.AwsConfig;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventPublisher.class);
    private final AmazonCloudWatchEvents eventsClient;

    public EventPublisher(AwsConfig awsConfig) {
        this(AwsClientFactory.createEventsClient(awsConfig));
    }

    public void putEvent(String source, String type, String detail, String ... resources) {
        PutEventsRequestEntry requestEntry = new PutEventsRequestEntry().withTime(new Date()).withSource(source).withResources(resources).withDetailType(type).withDetail(detail);
        PutEventsRequest request = new PutEventsRequest().withEntries(new PutEventsRequestEntry[]{requestEntry});
        PutEventsResult putEventsResult = this.eventsClient.putEvents(request);
        if (putEventsResult.getFailedEntryCount() > 0) {
            log.error("failed to put events: " + putEventsResult.toString());
        }
    }

    public EventPublisher(AmazonCloudWatchEvents eventsClient) {
        this.eventsClient = eventsClient;
    }
}

