/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.STSSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.aws.config.ConfigCredsProvider;
import io.polyglotted.common.util.MapBuilder;
import java.util.Map;

public enum CredsProvider {
    CONFIG{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new ConfigCredsProvider(config);
        }
    }
    ,
    ENVIRONMENT{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new EnvironmentVariableCredentialsProvider();
        }
    }
    ,
    SYSTEM_PROPERTIES{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new SystemPropertiesCredentialsProvider();
        }
    }
    ,
    PROFILE{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new ProfileCredentialsProvider();
        }
    }
    ,
    CONTAINER{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new EC2ContainerCredentialsProviderWrapper();
        }
    }
    ,
    STS_ROLE{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.getRoleArn(), config.getRoleSessionName()).withStsClient((AWSSecurityTokenService)AWSSecurityTokenServiceClientBuilder.standard().build()).build();
        }
    }
    ,
    STS_ROLE_PROXY{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(config.getRoleArn(), config.getRoleSessionName()).withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new ConfigCredsProvider(config))).build()).build();
        }
    }
    ,
    STS_SESSION{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSSessionCredentialsProvider((AWSCredentialsProvider)new EnvironmentVariableCredentialsProvider());
        }
    }
    ,
    STS_SESSION_PROXY{

        @Override
        AWSCredentialsProvider provider(AwsConfig config) {
            return new STSSessionCredentialsProvider((AWSCredentialsProvider)new ConfigCredsProvider(config));
        }
    };

    private static final Map<String, CredsProvider> INSTANCES;

    abstract AWSCredentialsProvider provider(AwsConfig var1);

    public static AWSCredentialsProvider getProvider(AwsConfig config) {
        return INSTANCES.get(config.getProvider()).provider(config);
    }

    static {
        MapBuilder.ImmutableMapBuilder builder = MapBuilder.immutableMapBuilder();
        for (CredsProvider value : CredsProvider.values()) {
            builder.put((Object)value.name(), (Object)value).put((Object)value.name().toLowerCase(), (Object)value);
        }
        INSTANCES = builder.build();
    }
}

