/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.config;

import com.amazonaws.regions.Regions;
import io.polyglotted.common.config.Attribute;
import io.polyglotted.common.config.Settings;

@Settings
public interface AwsConfig {
    public static final int MAX_MESSAGE_SIZE = 262144;

    @Attribute(name="aws.access_key")
    default public String getAccessKey() {
        return "";
    }

    @Attribute(name="aws.secret_key", encrypted=true)
    default public String getSecretKey() {
        return "";
    }

    @Attribute(name="aws.provider")
    default public String getProvider() {
        return "environment";
    }

    @Attribute(name="aws.region")
    default public String getRegion() {
        return "eu-west-1";
    }

    @Attribute(name="aws.role_arn")
    default public String getRoleArn() {
        return "";
    }

    @Attribute(name="aws.role_session_name")
    default public String getRoleSessionName() {
        return "defaultSession";
    }

    default public Regions regions() {
        return Regions.fromName((String)this.getRegion());
    }

    public static class DefaultAwsConfig
    implements AwsConfig {
        private String accessKey;
        private String secretKey;
        private String provider = "environment";
        private String region = "eu-west-1";
        private String roleArn = null;
        private String roleSessionName = "defaultSession";

        @Override
        public String getAccessKey() {
            return this.accessKey;
        }

        @Override
        public String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public String getProvider() {
            return this.provider;
        }

        @Override
        public String getRegion() {
            return this.region;
        }

        @Override
        public String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public String getRoleSessionName() {
            return this.roleSessionName;
        }

        public DefaultAwsConfig setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public DefaultAwsConfig setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public DefaultAwsConfig setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public DefaultAwsConfig setRegion(String region) {
            this.region = region;
            return this;
        }

        public DefaultAwsConfig setRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public DefaultAwsConfig setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }
    }
}

