/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.common;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.AWSSimpleSystemsManagementException;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import io.polyglotted.aws.common.AwsClientFactory;
import io.polyglotted.aws.config.AwsConfig;

public abstract class SsmHelper {
    public static String readParam(AwsConfig awsConfig, String keyPath) {
        return SsmHelper.readParam(awsConfig, keyPath, true);
    }

    public static String readParam(AwsConfig awsConfig, String keyPath, boolean decryptionOn) {
        AWSSimpleSystemsManagement ssmClient = AwsClientFactory.createSsmClient(awsConfig);
        try {
            GetParameterResult result = ssmClient.getParameter(new GetParameterRequest().withName(keyPath).withWithDecryption(Boolean.valueOf(decryptionOn)));
            return result.getParameter().getValue();
        }
        catch (AWSSimpleSystemsManagementException pfe) {
            return "";
        }
    }
}

