/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.common;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import io.polyglotted.aws.common.AwsClientFactory;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.MapRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class S3Fetcher {
    public static ObjectMetadata fetchObjectMetadata(AwsConfig config, String bucket, String key) {
        return AwsClientFactory.createS3Client(config).getObjectMetadata(bucket, key);
    }

    public static S3Object fetchObject(AmazonS3 client, GetObjectRequest request) {
        return client.getObject(request);
    }

    public static InputStream fetchPartial(AwsConfig config, String bucket, String key, long[] range) {
        GetObjectRequest request = new GetObjectRequest(bucket, key);
        if (range != null) {
            request.setRange(range[0], range[1]);
        }
        return S3Fetcher.fetchObject(AwsClientFactory.createS3Client(config), request).getObjectContent();
    }

    public static InputStream fetchMayBeSecure(AwsConfig config, String bucket, String key) throws IOException {
        return S3Fetcher.fetchMayBeSecure(config, bucket, key, S3Fetcher.fetchObjectMetadata(config, bucket, key));
    }

    public static InputStream fetchMayBeSecure(AwsConfig config, String bucket, String key, ObjectMetadata metadata) {
        String cmkId = S3Fetcher.fetchCmkId(metadata);
        AmazonS3 client = cmkId == null ? AwsClientFactory.createS3Client(config) : AwsClientFactory.s3EncryptionClient(config, cmkId);
        return S3Fetcher.fetchObject(client, new GetObjectRequest(bucket, key)).getObjectContent();
    }

    private static String fetchCmkId(ObjectMetadata metadata) {
        String matDesc = metadata.getUserMetaDataOf("x-amz-matdesc");
        return matDesc == null ? null : MapRetriever.reqdStr((Map)BaseSerializer.deserialize((String)matDesc), (String)"kms_cmk_id");
    }
}

