/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.common;

import com.amazonaws.services.s3.model.ObjectMetadata;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.NullUtil;
import javax.activation.MimetypesFileTypeMap;

public abstract class AwsContentUtil {
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String BINARY_STREAM = "binary/octet-stream";
    private static final MimetypesFileTypeMap MIME_MAP = new MimetypesFileTypeMap();

    public static ObjectMetadata contentTypeMetaData(String fileName) {
        return AwsContentUtil.contentTypeMetaData(fileName, null);
    }

    public static ObjectMetadata contentTypeMetaData(String fileName, Long contentLength) {
        ObjectMetadata omd = new ObjectMetadata();
        omd.setContentType(MIME_MAP.getContentType(fileName));
        if (contentLength != null) {
            omd.setContentLength(contentLength.longValue());
        }
        return omd;
    }

    public static String fetchContentType(ObjectMetadata metadata, MapResult attachment, String file) {
        return (String)NullUtil.nonNull((Object)AwsContentUtil.nullIf(metadata.getContentType()), (Object)AwsContentUtil.nullIf((String)MapRetriever.deepRetrieve((Object)attachment, (String)"indexed.content_type")), (Object)AwsContentUtil.defaultMimeType(file));
    }

    public static String defaultMimeType(String file) {
        return MIME_MAP.getContentType(file);
    }

    protected static String nullIf(String value) {
        return OCTET_STREAM.equals(NullUtil.nonNull((Object)value, (Object)OCTET_STREAM)) ? null : (BINARY_STREAM.equals(NullUtil.nonNull((Object)value, (Object)BINARY_STREAM)) ? null : value);
    }
}

