/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.aws.common;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClientBuilder;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProvider;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.aws.config.CredsProvider;

public abstract class AwsClientFactory {
    public static AmazonS3 createS3Client(AwsConfig config) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }

    public static AmazonS3Encryption s3EncryptionClient(AwsConfig config, String cmkId) {
        return (AmazonS3Encryption)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClient.encryptionBuilder().withCredentials(CredsProvider.getProvider(config))).withEncryptionMaterials((EncryptionMaterialsProvider)new KMSEncryptionMaterialsProvider(cmkId)).withCryptoConfiguration(new CryptoConfiguration().withAwsKmsRegion(RegionUtils.getRegion((String)config.getRegion()))).withRegion(config.regions())).build();
    }

    public static AmazonSQS createSqsClient(AwsConfig config) {
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }

    public static AmazonSNS createSnsClient(AwsConfig config) {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }

    public static AWSSimpleSystemsManagement createSsmClient(AwsConfig config) {
        return (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }

    public static AmazonCloudWatchEvents createEventsClient(AwsConfig config) {
        return (AmazonCloudWatchEvents)((AmazonCloudWatchEventsClientBuilder)((AmazonCloudWatchEventsClientBuilder)AmazonCloudWatchEventsClientBuilder.standard().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }

    public static AWSCognitoIdentityProvider cognitoClient(AwsConfig config) {
        return (AWSCognitoIdentityProvider)((AWSCognitoIdentityProviderClientBuilder)((AWSCognitoIdentityProviderClientBuilder)AWSCognitoIdentityProviderClient.builder().withCredentials(CredsProvider.getProvider(config))).withRegion(config.regions())).build();
    }
}

