package io.polyglotted.aws.message;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.polyglotted.aws.config.AwsConfig;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import static io.polyglotted.aws.common.AwsClientFactory.createSqsClient;

@SuppressWarnings({"unused", "WeakerAccess"})
@Slf4j @RequiredArgsConstructor
public class SqsPublisher {
    private final AmazonSQS sqsClient;

    public SqsPublisher(AwsConfig awsConfig) { this(createSqsClient(awsConfig)); }

    public void publish(QueueConfig config, String route, String json) { publish(config, route, json, null); }

    public void publish(QueueConfig config, String route, String json, String dedupeId) {
        if (json.length() > AwsConfig.MAX_MESSAGE_SIZE) {
            log.error("sqs message exceeded max size: " + json); return;
        }
        else if (!config.pattern().matcher(route).matches()) { return; }
        try {
            final String queueUrl = sqsClient.getQueueUrl(config.getQueue()).getQueueUrl();
            sqsClient.sendMessage(new SendMessageRequest(queueUrl, json)
                .withMessageGroupId(config.isFifo() ? route : null).withMessageDeduplicationId(dedupeId));
            log.info("published " + route + " on queue {}", queueUrl);

        } catch (Exception ex) { log.error("error publishing " + route + " on queue " + config.getQueue(), ex); }
    }
}