package io.polyglotted.aws.message;

import io.polyglotted.common.config.SettingsHolder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import static io.polyglotted.aws.message.QueueConfig.queueConfig;

@NoArgsConstructor @Accessors(chain = true)
public class SqsConfig {
    private static final QueueConfig _DEFAULT = new QueueConfig().setEnabled(false);
    @Getter @Setter private List<QueueConfig> queueConfigs = new LinkedList<>();

    public QueueConfig findConfig(int index) { return index >= 0 && index < queueConfigs.size() ? queueConfigs.get(index) : _DEFAULT; }

    public QueueConfig findConfig(String name) {
        for (QueueConfig publisher : queueConfigs) { if (name.equals(publisher.getName())) { return publisher; } } return _DEFAULT;
    }

    public static SqsConfig sqsConfig(SettingsHolder holder, String prefix) {
        int qConfigs = holder.intValue(prefix + ".queueConfigs.count", 0);
        List<QueueConfig> configs = new ArrayList<>();
        for (int i = 0; i < qConfigs; i++) {
            configs.add(queueConfig(holder, prefix + ".queueConfigs." + i));
        }
        return new SqsConfig().setQueueConfigs(configs);
    }
}