package io.polyglotted.aws.message;

import com.amazonaws.services.sns.AmazonSNS;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.common.config.SettingsHolder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import static io.polyglotted.aws.common.AwsClientFactory.createSnsClient;

@Slf4j
@RequiredArgsConstructor
public class SnsPublisher {
    private final AmazonSNS snsClient;

    public SnsPublisher(AwsConfig awsConfig) { this(createSnsClient(awsConfig)); }

    public void publish(SnsConfig snsConfig, String subject, String json) {
        if (json.length() > AwsConfig.MAX_MESSAGE_SIZE) {
            log.warn("message exceeded max size: " + json); return;
        }
        try {
            snsClient.publish(snsConfig.getTopic(), json, subject);
            log.info("published notification on topic {}", snsConfig.getTopic());

        } catch (Exception ex) { log.error("error publishing sns on topic " + snsConfig.getTopic(), ex); }
    }

    public static SnsConfig snsConfig(SettingsHolder holder, String prefix) {
        return new SnsConfig().setEnabled(holder.booleanValue(prefix + ".enabled", false))
            .setTopic(holder.stringValue(prefix + ".topic", "_null"));
    }

    @NoArgsConstructor @Getter @Setter @Accessors(chain = true)
    public static class SnsConfig {
        private boolean enabled = true;
        private String topic = "";
    }
}