package io.polyglotted.aws.message;

import io.polyglotted.common.config.SettingsHolder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.regex.Pattern;

@NoArgsConstructor @Accessors(chain = true)
public class QueueConfig {
    @Getter @Setter private String name = "_default";
    @Getter @Setter private boolean enabled = true;
    @Getter @Setter private String queue = "";
    @Getter @Setter private boolean fifo = false;
    @Getter @Setter private String filter = ".*";
    @Getter @Setter private int maxMessages = 1;
    @Getter @Setter private int waitTimeInSeconds = 20;
    @Getter @Setter private long shutdownTimeInMillis = 100;
    private transient Pattern _pattern;

    Pattern pattern() { return _pattern != null ? _pattern : (_pattern = Pattern.compile(filter)); }

    @SuppressWarnings("unused") public static QueueConfig queueConfig(SettingsHolder holder, String prefix) {
        return new QueueConfig().setName(holder.stringValue(prefix + ".name", "_default"))
            .setEnabled(holder.booleanValue(prefix + ".enabled", false))
            .setQueue(holder.stringValue(prefix + ".queue", "_none_"))
            .setFifo(holder.booleanValue(prefix + ".fifo", false))
            .setFilter(holder.stringValue(prefix + ".filter", ".*"))
            .setMaxMessages(holder.intValue(prefix + ".max_messages", 1))
            .setWaitTimeInSeconds(holder.intValue(prefix + ".wait_time_seconds", 20))
            .setShutdownTimeInMillis(holder.intValue(prefix + ".shutdown_time_millis", 100));
    }
}