package io.polyglotted.aws.message;

import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequestEntry;
import com.amazonaws.services.cloudwatchevents.model.PutEventsResult;
import io.polyglotted.aws.config.AwsConfig;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;

import static io.polyglotted.aws.common.AwsClientFactory.createEventsClient;

@Slf4j
@RequiredArgsConstructor
public class EventPublisher {
    private final AmazonCloudWatchEvents eventsClient;

    public EventPublisher(AwsConfig awsConfig) {
        this(createEventsClient(awsConfig));
    }

    public void putEvent(String source, String type, String detail, String... resources) {
        PutEventsRequestEntry requestEntry = new PutEventsRequestEntry().withTime(new Date())
                .withSource(source).withResources(resources).withDetailType(type).withDetail(detail);

        PutEventsRequest request = new PutEventsRequest().withEntries(requestEntry);
        PutEventsResult putEventsResult = eventsClient.putEvents(request);
        if (putEventsResult.getFailedEntryCount() > 0) {
            log.error("failed to put events: " + putEventsResult.toString());
        }
    }
}