package io.polyglotted.aws.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
class ConfigCredsProvider implements AWSCredentialsProvider {
    private final AwsConfig config;

    @Override public AWSCredentials getCredentials() { return new BasicAWSCredentials(config.getAccessKey(), config.getSecretKey()); }

    @Override public void refresh() { }
}