package io.polyglotted.aws.config;

import com.amazonaws.regions.Regions;
import io.polyglotted.common.config.Attribute;
import io.polyglotted.common.config.Settings;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

@Settings
public interface AwsConfig {
    int MAX_MESSAGE_SIZE = 262144; //256KB

    @Attribute(name = "aws.access_key")
    default String getAccessKey() { return ""; }

    @Attribute(name = "aws.secret_key", encrypted = true)
    default String getSecretKey() { return ""; }

    @Attribute(name = "aws.provider")
    default String getProvider() { return "environment"; }

    @Attribute(name = "aws.region")
    default String getRegion() { return "eu-west-1"; }

    @Attribute(name = "aws.role_arn")
    default String getRoleArn() { return ""; }

    @Attribute(name = "aws.role_session_name")
    default String getRoleSessionName() { return "defaultSession"; }

    default Regions regions() { return Regions.fromName(getRegion()); }

    @NoArgsConstructor @Getter @Setter @Accessors(chain = true)
    class DefaultAwsConfig implements AwsConfig {
        private String accessKey;
        private String secretKey;
        private String provider = "environment";
        private String region = "eu-west-1";
        private String roleArn = null;
        private String roleSessionName = "defaultSession";
    }
}