package io.polyglotted.aws.common;

import com.amazonaws.services.s3.model.ObjectMetadata;
import io.polyglotted.common.model.MapResult;

import javax.activation.MimetypesFileTypeMap;

import static io.polyglotted.common.util.MapRetriever.deepRetrieve;
import static io.polyglotted.common.util.NullUtil.nonNull;

@SuppressWarnings({"unused", "WeakerAccess"})
public abstract class AwsContentUtil {
    private static final String OCTET_STREAM = "application/octet-stream";
    private static final String BINARY_STREAM = "binary/octet-stream";
    private static final MimetypesFileTypeMap MIME_MAP = new MimetypesFileTypeMap();

    public static ObjectMetadata contentTypeMetaData(String fileName) { return contentTypeMetaData(fileName, null); }

    public static ObjectMetadata contentTypeMetaData(String fileName, Long contentLength) {
        ObjectMetadata omd = new ObjectMetadata();
        omd.setContentType(MIME_MAP.getContentType(fileName));
        if (contentLength != null) { omd.setContentLength(contentLength); }
        return omd;
    }

    public static String fetchContentType(ObjectMetadata metadata, MapResult attachment, String file) {
        return nonNull(nullIf(metadata.getContentType()), nullIf(deepRetrieve(attachment, "indexed.content_type")), defaultMimeType(file));
    }

    public static String defaultMimeType(String file) { return MIME_MAP.getContentType(file); }

    protected static String nullIf(String value) {
        return OCTET_STREAM.equals(nonNull(value, OCTET_STREAM)) ? null : BINARY_STREAM.equals(nonNull(value, BINARY_STREAM)) ? null : value;
    }
}