package io.polyglotted.aws.common;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClient;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClientBuilder;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProvider;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClient;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.polyglotted.aws.config.AwsConfig;
import io.polyglotted.aws.config.CredsProvider;

@SuppressWarnings("WeakerAccess")
public abstract class AwsClientFactory {
    public static AmazonS3 createS3Client(AwsConfig config) {
        return AmazonS3ClientBuilder.standard()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }

    public static AmazonS3Encryption s3EncryptionClient(AwsConfig config, String cmkId) {
        return AmazonS3EncryptionClient.encryptionBuilder()
            .withCredentials(CredsProvider.getProvider(config))
            .withEncryptionMaterials(new KMSEncryptionMaterialsProvider(cmkId))
            .withCryptoConfiguration(new CryptoConfiguration()
                .withAwsKmsRegion(RegionUtils.getRegion(config.getRegion())))
            .withRegion(config.regions()).build();
    }

    public static AmazonSQS createSqsClient(AwsConfig config) {
        return AmazonSQSClientBuilder.standard()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }

    public static AmazonSNS createSnsClient(AwsConfig config) {
        return AmazonSNSClientBuilder.standard()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }

    public static AWSSimpleSystemsManagement createSsmClient(AwsConfig config) {
        return AWSSimpleSystemsManagementClientBuilder.standard()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }

    public static AmazonCloudWatchEvents createEventsClient(AwsConfig config) {
        return AmazonCloudWatchEventsClientBuilder.standard()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }

    public static AWSCognitoIdentityProvider cognitoClient(AwsConfig config) {
        return AWSCognitoIdentityProviderClient.builder()
            .withCredentials(CredsProvider.getProvider(config))
            .withRegion(config.regions())
            .build();
    }
}